<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Box Widget .
 *
 */
class Konta_Contact_2 extends Widget_Base {

	public function get_name() {
		return 'drillercontactus';
	}

	public function get_title() {
		return __( 'Contact Form v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Contact', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'feature_style',
			[
				'label' 		=> __( 'Contact Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
				],
			]
		);

		$this->add_control(
			'heading',
			[
				'label'     => __( 'Heading', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'content',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::WYSIWYG,
			]
        );
        $this->add_control(
			'form_title',
			[
				'label'     => __( 'Form Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'shortcode',
			[
				'label'     => __( 'Form Shortcode', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );

        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'Konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Button Text', 'Konta' )
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'Konta' ),
				'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '#', 'Konta' ),
                'rows' 		=> 2,
			]
		);
		$this->add_control(
            'banner_img',
            [
                'label'     => __( 'BG Image', 'Konta' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );

        $this->end_controls_section();

        /*-----------------------------------------title styling------------------------------------*/

        $this->start_controls_section(
			'con_title_styling',
			[
				'label' 	=> __( 'Heading Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'con_title_color',
			[
				'label' 		=> __( 'Heading Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sub-title'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'con_title_typography',
		 		'label' 		=> esc_html__( 'Heading Typography', 'Konta' ),
		 		'selector' 		=> '{{WRAPPER}} .sub-title',
		 	]
		);

        $this->add_responsive_control(
			'con_title_margin',
			[
				'label' 		=> __( 'Heading Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'con_title_padding',
			[
				'label' 		=> __( 'Heading Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

        /*-----------------------------------------title styling------------------------------------*/

        $this->start_controls_section(
			'con_t_title_styling',
			[
				'label' 	=> __( 'Title Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'con_t_title_color',
			[
				'label' 		=> __( 'Title Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h4'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'con_t_title_typography',
		 		'label' 		=> esc_html__( 'Title Typography', 'Konta' ),
		 		'selector' 		=> '{{WRAPPER}} h4',
		 	]
		);

        $this->add_responsive_control(
			'con_t_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'con_t_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();

         $this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Button Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Button Color Hover', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( 'Button Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( 'Button Background Hover Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:before' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border_hover',
				'label' 	=> __( 'Border Hover', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn:hover',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'Konta' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
        );

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'Konta' ),
				'selector' => '{{WRAPPER}} .th-btn',
			]
		);
        $this->end_controls_section();


        
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        

        echo '<div class="">';
        	if(!empty($settings['banner_img']['url'])){
		        echo '<div class="th-container6" data-bg-src="'.esc_url($settings['banner_img']['url']).'">';
		    }
	            echo '<div class="container">';
	                echo '<div class="row justify-content-end">';
	                    echo '<div class="col-xxl-9 col-lg-11 py-5 my-3">';
	                    	echo '<div class="contact-wrap4">';
		                        echo '<div class="row gx-0 gy-0">';
		                            echo '<div class="col-lg-4">';
		                                echo '<div class="bg-theme box-wrap1">';
		                                    echo '<div class="title-area mb-50">';
		                                    if(!empty($settings['heading'])){
		                                        echo '<span class="sub-title6 text-white">'.esc_html($settings['heading']).'<span class="shape bg-white right"><span class="dots"></span></span></span>';
		                                    }
		                                    if(!empty($settings['title'])){
			                                    echo '<h4 class="sec-title text-white">'.esc_html($settings['title']).'</h4>';
			                                }
		                                    echo '</div>';
		                                    if(!empty($settings['content'])){
			                                    echo wp_kses_post($settings['content']);
			                                }
			                                if(!empty($settings['button_text'])){
			                                    echo '<div class="mt-5">';
			                                        echo '<a href="'.esc_url($settings['button_link']).'" class="th-btn style6">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                                    echo '</div>';
			                                }
		                                echo '</div>';
		                            echo '</div>';
		                            echo '<div class="col-lg-8">';

		                            if(!empty($settings['shortcode'])){
		                            	echo '<div class="contact-form-wrap bg-white">';
		                            		echo '<h3 class="form-title text-center">'.esc_html($settings['form_title']).'</h3>';
		                            		echo do_shortcode( $settings['shortcode']);
		                            	echo '</div>';
		                            } 
		                            echo '</div>';
		                        echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	           echo ' </div>';
	        echo '</div>';
	    echo '</div>';


        
	}
}