<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Download Button Box Widget .
 *
 */
class Konta_Download_Box_2 extends Widget_Base {

	public function get_name() {
		return 'drillerdownloadbutton2';
	}

	public function get_title() {
		return __( 'Download Button v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Download Button', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        
		$this->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'url',
			[
				'label'     => __( 'File Url', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'files',
			[
				'label' 		=> __( 'Files', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'url' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);
		
		
        
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();


        echo '<div class="widget widget_download">';
			if( ! empty( $settings['title'] ) ){
		        echo '<h4 class="widget_title">'.esc_html( $settings['title'] ).'</h4>';
		    }
			echo '<div class="donwload-widget-wrap">';
				foreach( $settings['files'] as $data ) {
					if( ! empty( $data['title'] ) ){
					    echo '<a href="'.esc_url($data['url']).'" class="th-btn"><i class="fa-light fa-file-pdf me-2"></i>'.esc_html( $data['title'] ).'</a>';
					}
				}
			echo '</div>';
		echo '</div>';
	}
}