<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Gallery Widget .
 *
 */
class Konta_Gallery_2 extends Widget_Base {

	public function get_name() {
		return 'drillergallery';
	}

	public function get_title() {
		return __( 'Gallery v2', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'gallery_section',
			[
				'label'		 	=> __( 'Gallery', 'Konta' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'gallery',
			[
				'label' => esc_html__( 'Add Gallery Slider', 'aduki' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
?>
	<div class="sidebar-gallery">
		<?php foreach ( $settings['gallery'] as $single_data ): ?>
        <div class="gallery-thumb">
           <?php echo Konta_img_tag( array(
				'url'   => esc_url( $single_data['url'] )
			) ); ?>
        </div>
		<?php endforeach; ?>
    </div>
      <?php
	}
}