<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * iamge tab Box Widget .
 *
 */
class Konta_Image_Tab_Box_2 extends Widget_Base {

	public function get_name() {
		return 'drilleriamgetab';
	}

	public function get_title() {
		return __( 'Image Tab v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Tab', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
		$repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'skills',
			[
				'label' 		=> __( 'Skills', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Your Name', 'Konta' ),
					],
				],
				'title_field' 	=> '{{{ title }}}',
			]
		);
        $this->end_controls_section();

        //-------------------------------------subtitle styling-------------------------------------//

        $this->start_controls_section(
			'style',
			[
				'label' => __( 'Style', 'Konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label' 		=> __( 'Active Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tab-menu4' => '--theme-color: {{VALUE}}!important',
                ],
			]
        );
        $this->end_controls_section();

        /*-----------------------------------------features styling------------------------------------*/

		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Title Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .tab-menu4 button'	=> '--title-color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} .tab-menu4 button',
			]
		);
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

    	echo '<div class="tab-menu4 filter-menu-active">';
    		$i = 0;
        	foreach( $settings['skills'] as $data ) { 
        		$i++;
        		$active_class = ($i == 1) ? 'active' : '';
	        	$title = $data['title'];
	        
                echo '<button data-filter=".'.esc_attr($i).'" class="'.esc_attr($active_class).'" type="button">'.esc_html($title).'</button>';    
            }
        echo '</div>';
        echo '<div class="filter-active-1">';
        	$i = 0;
        	foreach( $settings['skills'] as $data ) {
        		$i++;
        		$filter = $i;

                echo '<div class="filter-item w-100 '.esc_attr($filter).'">';
                    echo '<div class="growth-chart">';
                    	if(!empty($data['image']['url'])){
	                        echo Konta_img_tag( array(
			                    'url'   => esc_url( $data['image']['url']  ),
			                ));
	                    }
                    echo '</div>';
                echo '</div>';
            }

        echo '</div>';
	}

}