<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Box Widget .
 *
 */
class Konta_Video_Thumb_2 extends Widget_Base {

	public function get_name() {
		return 'drillervdothumb';
	}

	public function get_title() {
		return __( 'Video Thumb v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Feature', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'shape_image',
			[
				'label' 		=> __( 'Shape Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'video',
			[
				'label'     => __( 'Video URL', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 	=> 'https://www.youtube.com/watch?v=_sI_Ps7JSEk',
			]
        );

        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();


        echo '<div class="video-box1">';
        	if( ! empty( $settings['image']['url'] ) ){
	            echo '<div class="img1">';
	                echo Konta_img_tag( array(
						'url'   => esc_url( $settings['image']['url'] ),
					) );
	            echo '</div>';
	        }
           	echo ' <div class="text-end">';
           		if( ! empty( $settings['shape_image']['url'] ) ){
	                echo '<div class="bg-shape bg-theme">';
	                    echo Konta_img_tag( array(
							'url'   => esc_url( $settings['shape_image']['url'] ),
						) );
	                echo '</div>';
	            }
            echo '</div>';
            echo '<div class="play-bg bg-theme" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/bg_pattern_7.png">';
                echo '<a href="'.esc_url( $settings['video'] ).'" class="play-btn popup-video"><i class="fas fa-play"></i></a>';
            echo '</div>';
        echo '</div>';
	}

}