<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Mission Box Widget .
 *
 */
class Konta_Mission_Box_2 extends Widget_Base {

	public function get_name() {
		return 'drillermission';
	}

	public function get_title() {
		return __( 'Mission v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Mission', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'misson_style',
			[
				'label' 		=> __( 'Misson Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
					'3' 		=> __( 'Style Three', 'Konta' ),
				],
			]
		); 
        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'features',
			[
				'label'     => __( 'Features', 'Konta' ),
                'type'      => Controls_Manager::WYSIWYG,
			]
        );
		$repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'steps',
			[
				'label' 		=> __( 'Mission', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'Konta' ),
					],
				],
				'condition' => [
					'misson_style!' => '3',
				]
			]
		);


		$repeater2 = new Repeater();

		$repeater2->add_control(
			'tab_title',
			[
				'label'     => __( 'Tab Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater2->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater2->add_control(
			'video_link',
			[
				'label'     => __( 'Video Link', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
		
		$repeater2->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater2->add_control(
			'content',
			[
				'label'     => __( 'Content', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater2->add_control(
			'features',
			[
				'label'     => __( 'Features', 'Konta' ),
                'type'      => Controls_Manager::WYSIWYG,
			]
        );        
        $repeater2->add_control(
			'features2',
			[
				'label'     => __( 'Features 2', 'Konta' ),
                'type'      => Controls_Manager::WYSIWYG,
			]
        );

        $this->add_control(
			'steps2',
			[
				'label' 		=> __( 'Mission', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'Konta' ),
					],
				],
				'condition' => [
					'misson_style' => '3',
				]
			]
		);

        $this->end_controls_section();

          /*-----------------------------------------GENERAL styling------------------------------------*/

        $this->start_controls_section(
			'basic_styling',
			[
				'label' 	=> __( 'General Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'misson_style' => '3',
				]
			]
        );

        $this->add_control(
			'general_color',
			[
				'label' 		=> __( ' Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} button'	=> 'color: {{VALUE}}!important;',
				]
			]
        );      
         $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'genearal_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} button',
			]
		);   
        $this->add_control(
			'general_active_color',
			[
				'label' 		=> __( 'Active Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} button.active'	=> 'color: {{VALUE}}!important;',
				]
			]
        );          
        $this->add_control(
			'general_active_bg_color',
			[
				'label' 		=> __( 'Active Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} button.active'	=> '--theme-color: {{VALUE}}!important;',
				]
			]
        );  


        $this->end_controls_section();


        /*-----------------------------------------features styling------------------------------------*/

		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Title Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} h3'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} h3',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
        /*-----------------------------------------features content styling------------------------------------*/

		$this->start_controls_section(
			'content_section',
			[
				'label' 	=> __( 'Content Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
		$this->add_control(
			'content_color',
			[
				'label' 		=> __( 'Color', 'appku' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} p'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'content_typography',
		 		'label' 		=> __( 'Typography', 'appku' ),
		 		'selector' 	=> '{{WRAPPER}} p',
			]
		);

        $this->add_responsive_control(
			'content_margin',
			[
				'label' 		=> __( 'Margin', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'content_padding',
			[
				'label' 		=> __( 'Padding', 'appku' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if($settings['misson_style'] == 1 ){
    		$style = 3;
    	}else{
    		$style = 4;
    	}

    	if($settings['misson_style'] == 3 ){
    		echo '<div class="tab-menu2 filter-menu-active">';
            	$i = 0;
            	foreach( $settings['steps2'] as $data ) { 
            		$i++;
            		$active_class = ($i == 1) ? 'active' : '';
            		if($settings['misson_style'] == 1 ){
		        		$title = $i;
		        	}else{
		        		$title = $data['tab_title'];
		        	}
	                echo '<button data-filter=".'.esc_attr($i).'" class="'.esc_attr($active_class).'" type="button">'.esc_html($title).'</button>';    
	            }
            echo '</div>';

            echo '<div class="mission-box-wrap mt-50 filter-active-1">';
                $i = 0;
            	foreach( $settings['steps2'] as $data ) { 
            		$i++;
            		
            		$filter = $i;
            		
	                echo '<div class="filter-item '.esc_attr($filter).'">';
	                    echo '<div class="mission-grid">';
	                           	echo '<div class="mission-img rounded-20" data-overlay="title" data-opacity="2">';
		                              echo Konta_img_tag( array(
					                    'url'   => esc_url( $data['image']['url']  ),
					                ));
		                            if(!empty($data['video_link'])){
			                            echo '<a href="'.esc_url( $data['video_link'] ).'" class="play-btn style3 popup-video"><i class="fas fa-play"></i></a>';
			                        }
		                        echo '</div>';

		                        echo '<div class="mission-content">';
			                        if(!empty($data['title'])){
			                        	echo '<h3 class="mission-title">'.esc_html($data['title']).'</h3>';
				                    }
		                           if(!empty($data['content'])){
			                       		echo '<p class="mission-text">'.esc_html($data['content']).'</p>';
			                       	}
		                            if(!empty($data['features'])){
			                            echo '<div class="checklist style5">';
			                               echo wp_kses_post( $data['features'] );
			                            echo '</div>';
			                        }          
			                        if(!empty($data['features2'])){
			                            echo '<div class="mission-feature-wrap">';
			                               echo wp_kses_post( $data['features2'] );
			                            echo '</div>';
			                        }
		                           
		                        echo '</div>';

	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';

    	}else{
        echo '<div class="mission-area">';
        	
            echo '<div class="tab-menu'.esc_attr($style).' filter-menu-active">';
            	$i = 0;
            	foreach( $settings['steps'] as $data ) { 
            		$i++;
            		$active_class = ($i == 1) ? 'active' : '';
            		if($settings['misson_style'] == 1 ){
		        		$title = $i;
		        	}else{
		        		$title = $data['title'];
		        	}
	                echo '<button data-filter=".'.esc_attr($i).'" class="'.esc_attr($active_class).'" type="button">'.esc_html($title).'</button>';    
	            }
            echo '</div>';
            echo '<div class="mission-box-wrap filter-active-1">';
                $i = 0;
            	foreach( $settings['steps'] as $data ) { 
            		$i++;
            		
            		$filter = $i;
            		
	                echo '<div class="filter-item '.esc_attr($filter).'">';
	                    echo '<div class="mission-box">';
	                    	if(!empty($data['title'])){
		                        echo '<h3 class="h4 mission-title">'.esc_html($data['title']).'</h3>';
		                    }
		                    if(!empty($data['content'])){
	                       		echo '<p class="mission-text">'.esc_html($data['content']).'</p>';
	                       	}
	                        echo '<div class="checklist-wrap">';
	                        	if(!empty($data['image']['url'])){
		                            echo '<div class="mission-img">';
		                                echo Konta_img_tag( array(
						                    'url'   => esc_url( $data['image']['url']  ),
						                ));
		                            echo '</div>';
		                        }
	                            if(!empty($data['features'])){
		                       		echo wp_kses_post( $data['features'] );
		                       	}
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
                
            echo '</div>';
        echo '</div>';
        }

	}

}