<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Newslater Widget .
 *
 */
class Konta_Newslatter_Form_2 extends Widget_Base {

	public function get_name() {
		return 'drillernewslatterform';
	}

	public function get_title() {
		return __( 'Newslater v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta_footer_elements' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'newslatter_section',
			[
				'label' 	=> __( 'Newslatter', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'form_style',
			[
				'label' 		=> __( 'Blog Style', 'Konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'one',
				'options'		=> [
					'one'  			=> __( 'Style One', 'Konta' ),
					'two' 			=> __( 'Style Two', 'Konta' ),
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => __( 'Title', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $this->add_control(
			'subtitle',
			[
				'label'     => __( 'Subtitle', 'Konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'condition'		=> [ 'form_style' =>  ['one']  ],
			]
        );
        $this->add_control(
			'banner_image',
			[
				'label' 		=> __( 'Image', 'Konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'form_style' =>  ['two']  ],
			]
		);
		
        $this->end_controls_section();

        //-------------------------------------subtitle styling-------------------------------------//

        $this->start_controls_section(
			'style',
			[
				'label' => __( 'Style', 'Konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label' 		=> __( 'Background Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .contact-media' => 'background-color: {{VALUE}}!important',
                ],
			]
        );
        $this->end_controls_section();

        /*-----------------------------------------title styling------------------------------------*/

        $this->start_controls_section(
			'form_title_styling',
			[
				'label' 	=> __( 'Title Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'form_title_color',
			[
				'label' 		=> __( 'Title Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .subscribe-box_text,{{WRAPPER}} .newsletter-title'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'form_title_typography',
		 		'label' 		=> esc_html__( 'Title Typography', 'Konta' ),
		 		'selector' 		=> '{{WRAPPER}} .subscribe-box_text,{{WRAPPER}} .newsletter-title',
		 	]
		);

        $this->add_responsive_control(
			'form_title_margin',
			[
				'label' 		=> __( 'Title Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .subscribe-box_text, {{WRAPPER}} .newsletter-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'form_title_padding',
			[
				'label' 		=> __( 'Title Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .subscribe-box_text, {{WRAPPER}} .newsletter-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
        /*-----------------------------------------title styling------------------------------------*/

        $this->start_controls_section(
			'form_subtitle_styling',
			[
				'label' 	=> __( 'Subtitle Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'form_subtitle_color',
			[
				'label' 		=> __( 'Subtitle Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .subscribe-box_title'	=> 'color: {{VALUE}}!important;',
				]
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'form_subtitle_typography',
		 		'label' 		=> esc_html__( 'Subtitle Typography', 'Konta' ),
		 		'selector' 		=> '{{WRAPPER}} .subscribe-box_title',
		 	]
		);

        $this->add_responsive_control(
			'form_subtitle_margin',
			[
				'label' 		=> __( 'Subtitle Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .subscribe-box_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'form_subtitle_padding',
			[
				'label' 		=> __( 'Subtitle Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .subscribe-box_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['form_style'] == 'one' ){
	        echo '<div class="subscribe-box">';
	            echo '<div>';
	            	if(!empty($settings['title'])){
		                echo '<p class="subscribe-box_text">'.esc_html($settings['title']).'</p>';
		            }
		            if(!empty($settings['subtitle'])){
		                echo '<h4 class="subscribe-box_title">'.esc_html($settings['subtitle']).'</h4>';
		            }
	            echo '</div>';
	            echo '<form class="newsletter-form">';
	                echo '<input class="form-control" type="email" placeholder="'.esc_attr__('Enter Email Address', 'Konta').'" required="">';
	                echo '<button type="submit" class="th-btn style3">'.esc_html__('SUBCRIBE', 'Konta').'<i class="fas fa-arrow-right ms-2"></i></button>';
	            echo '</form>';
	        echo '</div>';
	    }else{
	    	echo '<div class="footer-spacer bg-smoke"></div>';
	        echo '<div class="container">';
	            echo '<div class="newsletter-wrap2">';
	            	if(!empty($settings['banner_image']['url'])){
		                echo '<div class="newsletter-shape">';
		                    echo Konta_img_tag( array(
								'url'	=> esc_url( $settings['banner_image']['url'] )
							) );
		                echo '</div>';
		            }
	                if(!empty($settings['title'])){
		                echo '<h2 class="newsletter-title">'.esc_html($settings['title']).'</h2>';
		            }
	                echo '<form class="newsletter-form">';
	                    echo '<input class="form-control" type="email" placeholder="'.esc_attr__('Enter Email Address', 'Konta').'" required="">';
	                    echo '<button type="submit" class="th-btn style5">'.esc_html__('SUBCRIBE', 'Konta').'<i class="fas fa-arrow-right ms-2"></i></button>';
	                echo '</form>';
	            echo '</div>';
	        echo '</div>';
	    }   
	}

}