<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Service Widget .
 *
 */
class Konta_Service_2 extends Widget_Base {

	public function get_name() {
		return 'drillerservice';
	}

	public function get_title() {
		return __( 'Service v2', 'Konta' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Service Slider', 'Konta' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'service_style',
			[
				'label' 	=> __( 'Service Style', 'Konta' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'Konta' ),
					'2' 		=> __( 'Style Two', 'Konta' ),
					'3' 		=> __( 'Style Three', 'Konta' ),
					'4' 		=> __( 'Style Four', 'Konta' ),
					'5' 		=> __( 'Style Five', 'Konta' ),
					'6' 		=> __( 'Style Six', 'Konta' ),
				],
			]
		);
		$this->add_control(
			'make_it_slider',
			[
				'label' 		=> __( 'Make It Slider?', 'Konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'Konta' ),
				'label_off' 	=> __( 'No', 'Konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'show_arrow',
			[
				'label' 		=> __( 'Show Arrow?', 'Konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'Konta' ),
				'label_off' 	=> __( 'No', 'Konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> ['make_it_slider' => ['yes']]
			]
		);
		$this->add_control(
			'show_dots',
			[
				'label' 		=> __( 'Show Dots?', 'Konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'Konta' ),
				'label_off' 	=> __( 'No', 'Konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> ['make_it_slider' => ['yes']]
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
			'service_slider_image',
			[
				'label'     => __( 'Service Slider Image', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'service_slider_icon_image',
			[
				'label'     => __( 'Service Icon', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'service_title',
            [
				'label'         => __( 'Service Title', 'Konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Neurology Specialist' , 'Konta' ),
				'label_block'   => true,
			]
		);
        $repeater->add_control(
			'service_description',
            [
				'label'         => __( 'Service Description', 'Konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'There are many variations injected many alteration humour believable.' ,'Konta' ),
				'label_block'   => true,
			]
		);

        $repeater->add_control(
            'button_text',
            [
                'label'         => __( 'Button Text', 'Konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
				'default'		=> __( 'View Details','Konta' )
            ]
        );

        $repeater->add_control(
            'button_url',
            [
                'label'         => __( 'Details Url', 'Konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
				'default'		=> '#'
            ]
        );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Service Slider', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{service_title}}',
				'condition'	=> ['service_style' => ['1','2','3','6']]
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
			'service_slider_image',
			[
				'label'     => __( 'Service Slider Image', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'service_slider_icon_image',
			[
				'label'     => __( 'Service Icon', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'service_slider_icon_image_overlay',
			[
				'label'     => __( 'Overlay Icon', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'service_title',
            [
				'label'         => __( 'Service Title', 'Konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Neurology Specialist' , 'Konta' ),
				'label_block'   => true,
			]
		);
        $repeater->add_control(
			'service_description',
            [
				'label'         => __( 'Service Description', 'Konta' ),
				'type'          => Controls_Manager::WYSIWYG,
				'default'       => __( 'There are many variations injected many alteration humour believable.' ,'Konta' ),
				'label_block'   => true,
			]
		);

        $repeater->add_control(
            'button_text',
            [
                'label'         => __( 'Button Text', 'Konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
				'default'		=> __( 'View Details','Konta' )
            ]
        );

        $repeater->add_control(
            'button_url',
            [
                'label'         => __( 'Details Url', 'Konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
				'default'		=> '#'
            ]
        );

		$this->add_control(
			'slides_2',
			[
				'label' 		=> __( 'Service Slider', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{service_title}}',
				'condition'	=> ['service_style' => '4']
			]
		);

		$repeater2 = new Repeater();

		$repeater2->add_control(
			'service_slider_icon_image',
			[
				'label'     => __( 'Service Icon', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $repeater2->add_control(
			'service_title',
            [
				'label'         => __( 'Service Title', 'Konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Neurology Specialist' , 'Konta' ),
				'label_block'   => true,
			]
		);
        $repeater2->add_control(
			'service_description',
            [
				'label'         => __( 'Service Description', 'Konta' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'There are many variations injected many alteration humour believable.' ,'Konta' ),
				'label_block'   => true,
			]
		);

        $repeater2->add_control(
            'button_text',
            [
                'label'         => __( 'Button Text', 'Konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
				'default'		=> __( 'View Details','Konta' )
            ]
        );

        $repeater2->add_control(
            'button_url',
            [
                'label'         => __( 'Details Url', 'Konta' ),
                'type'          => Controls_Manager::TEXTAREA,
                'label_block'   => true,
				'default'		=> '#'
            ]
        );

		$this->add_control(
			'slides_3',
			[
				'label' 		=> __( 'Service Slider', 'Konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
					[
						'service_slider_image' 	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{service_title}}',
				'condition'	=> ['service_style' => '5']
			]
		);

        $this->end_controls_section();


        $this->start_controls_section(
			'service_shape',
			[
				'label'     => __( 'Service Shape', 'Konta' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition'	=> ['service_style!' => '5']
			]
        );
        $this->add_control(
			'service_shape_image',
			[
				'label'     => __( 'Shape for BG', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'service_shape_btn',
			[
				'label'     => __( 'Shape for Button', 'Konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->end_controls_section();

		$this->start_controls_section(
			'service_slider_general_style',
			[
				'label' 	=> __( 'General Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'service_box_background',
			[
				'label' 		=> __( 'Service Box Background', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service-box_content,{{WRAPPER}} .service-card_content,{{WRAPPER}} .service-grid_content,{{WRAPPER}} .service-card_content::before,{{WRAPPER}} .service-block_content, {{WRAPPER}} .service-list, {{WRAPPER}} .service-card2' => 'background-color: {{VALUE}}',
                ]
			]
        );
		

		$this->end_controls_section();

		/*-----------------------------------------Feedback styling------------------------------------*/

		$this->start_controls_section(
			'overview_con_styling',
			[
				'label' 	=> __( 'Content Styling', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );
        $this->start_controls_tabs(
			'style_tabs2'
		);


		$this->start_controls_tab(
			'style_normal_tab2',
			[
				'label' => esc_html__( 'Button', 'Konta' ),
			]
		);
        $this->add_control(
			'overview_title_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_btn, {{WRAPPER}} .service-list_btn'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_title_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} .service-box2_btn, {{WRAPPER}} .service-list_btn',
			]
		);

        $this->add_responsive_control(
			'overview_title_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_btn, {{WRAPPER}} .service-list_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_title_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_btn, {{WRAPPER}} .service-list_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_tab();

		//--------------------secound--------------------//

		$this->start_controls_tab(
			'style_hover_tab2',
			[
				'label' => esc_html__( 'Title', 'Konta' ),
			]
		);
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_title,{{WRAPPER}} .service-card2_title,{{WRAPPER}} .service-grid_title,{{WRAPPER}} .service-block_title, {{WRAPPER}} .service-list_title, {{WRAPPER}} .service-list_title'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} .service-box2_title,{{WRAPPER}} .service-card2_title,{{WRAPPER}} .service-grid_title,{{WRAPPER}} .service-block_title, {{WRAPPER}} .service-list_title',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_title,{{WRAPPER}} .service-card2_title,{{WRAPPER}} .service-grid_title,{{WRAPPER}} .service-block_title, {{WRAPPER}} .service-list_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_title,{{WRAPPER}} .service-card2_title,{{WRAPPER}} .service-grid_title,{{WRAPPER}} .service-block_title, {{WRAPPER}} .service-list_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

		$this->end_controls_tab();


		//--------------------three--------------------//

		$this->start_controls_tab(
			'style_hover_tab3',
			[
				'label' => esc_html__( 'Description', 'Konta' ),
			]
		);
		$this->add_control(
			'counter_color',
			[
				'label' 		=> __( 'Color', 'Konta' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_text,{{WRAPPER}} .service-card_text,{{WRAPPER}} .service-grid_text,{{WRAPPER}} .service-block_text, {{WRAPPER}} .service-list_text'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'counter_typography',
		 		'label' 		=> __( 'Typography', 'Konta' ),
		 		'selector' 	=> '{{WRAPPER}} .service-box_tex,{{WRAPPER}} .service-card_text,{{WRAPPER}} .service-grid_text,{{WRAPPER}} .service-block_text, {{WRAPPER}} .service-list_text',
			]
		);

        $this->add_responsive_control(
			'counter_margin',
			[
				'label' 		=> __( 'Margin', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_text,{{WRAPPER}} .service-card_text,{{WRAPPER}} .service-grid_tex,{{WRAPPER}} .service-block_text, {{WRAPPER}} .service-list_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'counter_padding',
			[
				'label' 		=> __( 'Padding', 'Konta' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .service-box2_text,{{WRAPPER}} .service-card_text,{{WRAPPER}} .service-grid_text,{{WRAPPER}} .service-block_text, {{WRAPPER}} .service-list_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );



		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
   		if( $settings['service_style'] !== '2' ){
			if($settings['make_it_slider'] == 'yes'){

				if( $settings['show_arrow'] == 'yes' ){
					$this->add_render_attribute( 'wrapper', 'data-arrows', 'true' );
				}else{
					$this->add_render_attribute( 'wrapper', 'data-arrows', 'false' );
				}

				if( $settings['show_dots'] == 'yes' ){
					$this->add_render_attribute( 'wrapper', 'data-dots', 'true' );
				}else{
					$this->add_render_attribute( 'wrapper', 'data-dots', 'false' );
				}

				$this->add_render_attribute( 'wrapper', 'class', 'row service_slider_1' );
				
			}else{
				$this->add_render_attribute( 'wrapper', 'class', 'row gy-30' );
			}
		}
		if( $settings['service_style'] == '1' ){
			echo '<div class="service_1 slider-shadow arrow-wrap">';
				echo '<div '.$this->get_render_attribute_string('wrapper').'>';

			
                	foreach( $settings['slides'] as $service_slider ){
                		echo '<div class="col-md-6 col-lg-4 col-xl-3">';
                			if(!empty($settings['service_shape_image']['url'])){
			                    echo '<div class="service-box2" data-bg-src="'.esc_url($settings['service_shape_image']['url']).'">';
			                }
		                        echo '<div class="service-box2_content">';
		                            if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
				                        echo '<div class="service-box2_icon">';
				                            echo Konta_img_tag( array(
												'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
											) );
				                        echo '</div>';
				                    }
		                            if( ! empty( $service_slider['service_title'] ) ){
			                            echo '<h3 class="service-box2_title"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
			                        }
		                            if( ! empty( $service_slider['service_description'] ) ){
			                            echo '<p class="service-box2_text">'.esc_html( $service_slider['service_description'] ).'</p>';
			                        }
		                        echo '</div>';
		                        if( ! empty( $service_slider['button_text'] ) ){
			                        echo '<a href="'.esc_url( $service_slider['button_url'] ).'" data-bg-src="'.esc_url($settings['service_shape_btn']['url']).'" class="service-box2_btn">'.esc_html( $service_slider['button_text'] ).'<i class="fas fa-arrow-right"></i></a>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            }
	                
	            echo '</div>';
            echo '</div>';
		}elseif( $settings['service_style'] == '2' ){
			echo '<div class="service_2 arrow-wrap">';
				echo '<div class="row slider-shadow th-carousel dot-style3" data-slide-show="4" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-dots="true" data-xl-dots="true" data-ml-dots="true" data-lg-dots="true" data-md-dots="true">';
					foreach( $settings['slides'] as $service_slider ){
						echo '<div class="col-md-6 col-lg-4 col-xl-3">';
		                    echo '<div class="service-card2">';
		                        if( ! empty( $service_slider['service_slider_image']['url'] ) ){
			                        echo '<div class="service-card2_img">';
			                            echo Konta_img_tag( array(
											'url'   => esc_url( $service_slider['service_slider_image']['url'] ),
										) );
			                        echo '</div>';
			                    }
			                    if(!empty($settings['service_shape_image']['url'])){
			                        echo '<div class="service-card2_content" data-bg-src="'.esc_url($settings['service_shape_image']['url']).'">';
			                    }
		                            if( ! empty( $service_slider['service_title'] ) ){
			                            echo '<h3 class="service-card2_title"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
			                        }
		                            if( ! empty( $service_slider['service_description'] ) ){
			                            echo '<p class="service-card2_text">'.esc_html( $service_slider['service_description'] ).'</p>';
			                        }
		                            if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
				                        echo '<div class="service-card2_icon">';
				                            echo Konta_img_tag( array(
												'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
											) );
				                        echo '</div>';
				                    }
		                        echo '</div>';
		                        if( ! empty( $service_slider['button_url'] ) ){
			                        echo '<a href="'.esc_url( $service_slider['button_url'] ).'" class="service-card2_btn"><i class="fas fa-arrow-right"></i></a>';
			                    }
		                    echo '</div>';
		                echo '</div>'; 
		            }
	            echo '</div>';
	        echo '</div>';
		}elseif( $settings['service_style'] == '3' ){
			echo '<div class="service_3">';
				echo '<div '.$this->get_render_attribute_string('wrapper').'>';
					foreach( $settings['slides'] as $service_slider ){
						echo '<div class="col-md-6 col-xl-4">';
		                    echo '<div class="service-block">';
		                        if( ! empty( $service_slider['service_slider_image']['url'] ) ){
			                        echo '<div class="service-block_img">';
			                            echo Konta_img_tag( array(
											'url'   => esc_url( $service_slider['service_slider_image']['url'] ),
										) );
			                        echo '</div>';
			                    }
		                        echo '<div class="service-block_content">';
		                            if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
				                        echo '<div class="service-block_icon">';
				                            echo Konta_img_tag( array(
												'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
											) );
				                        echo '</div>';
				                    }
		                            if( ! empty( $service_slider['service_title'] ) ){
			                            echo '<h3 class="service-block_title"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
			                        }
		                            if( ! empty( $service_slider['service_description'] ) ){
			                            echo '<p class="service-block_text">'.esc_html( $service_slider['service_description'] ).'</p>';
			                        }
		                        echo '</div>';
		                        if( ! empty( $service_slider['button_text'] ) ){
			                        echo '<a href="'.esc_url( $service_slider['button_url'] ).'" class="th-btn">'.esc_html( $service_slider['button_text'] ).'<i class="fas fa-arrow-right ms-2"></i></a>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            }
	            echo '</div>';
	        echo '</div>';
		}elseif( $settings['service_style'] == '4' ){
			echo '<div class="row align-items-center">';
                echo '<div class="col-xl-8">';
                    echo '<div class="row def_custom-carousel_1" id="serviceGridSlider">';
                    	foreach( $settings['slides_2'] as $service_slider ){
	                        echo '<div class="col-md-6 col-lg-4 col-xl-3">';
	                            echo '<div class="service-grid">';
	                            	if( ! empty( $service_slider['service_slider_image']['url'] ) ){
		                                echo '<div class="service-grid_img">';
		                                    echo Konta_img_tag( array(
												'url'   => esc_url( $service_slider['service_slider_image']['url'] ),
											) );
		                                echo '</div>';
		                            }
	                                echo '<div class="service-grid_content">';
	                                	if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
		                                    echo '<div class="service-grid_icon">';
		                                        echo Konta_img_tag( array(
													'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
												) );
		                                    echo '</div>';
		                                }
		                                if( ! empty( $service_slider['service_slider_icon_image_overlay']['url'] ) ){
		                                    echo '<div class="service-grid_icon-overlay">';
		                                        echo Konta_img_tag( array(
													'url'   => esc_url( $service_slider['service_slider_icon_image_overlay']['url'] ),
												) );
		                                    echo '</div>';
		                                }
		                                if( ! empty( $service_slider['service_title'] ) ){
		                                    echo '<h3 class="service-grid_title"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
		                                }
	                                    if( ! empty( $service_slider['service_description'] ) ){
	                                    	echo wp_kses_post( $service_slider['service_description'] );
	                                    }
	                                    if( ! empty( $service_slider['button_text'] ) ){
		                                    echo '<a href="'.esc_url( $service_slider['button_url'] ).'" class="th-btn">'.esc_html( $service_slider['button_text'] ).'<i class="fas fa-arrow-right ms-2"></i></a>';
		                                }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                        
                    echo '</div>';
                echo '</div>';
                echo '<div class="col-xl-4">';
                    echo '<div class="service-thumb-wrap">';
                        echo '<button data-slick-prev="#serviceSlideThumb" class="arrow-btn prev"><i class="far fa-arrow-up"></i></button>';
                        
                        echo '<div class="def_custom-carousel" id="serviceSlideThumb">';
                        	foreach( $settings['slides_2'] as $service_slider ){
	                            echo '<div>';
	                                echo '<div class="service-thumb">';
	                                	if( ! empty( $service_slider['service_slider_image']['url'] ) ){
		                                    echo '<div class="service-thumb_img">';
		                                        echo Konta_img_tag( array(
													'url'   => esc_url( $service_slider['service_slider_image']['url'] ),
													'width'  	  => '70px',
													'height' 	  => '70px',
												) );
		                                    echo '</div>';
		                                }
		                                if( ! empty( $service_slider['service_title'] ) ){
		                                    echo '<h3 class="service-thumb_title">'.esc_html( $service_slider['service_title'] ).'</h3>';
		                                }
	                                echo '</div>';
	                            echo '</div>';
	                        }   
                        echo '</div>';
                        echo '<button data-slick-next="#serviceSlideThumb" class="arrow-btn next"><i class="far fa-arrow-down"></i></button>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['service_style'] == '5' ){
			echo '<div class="row gx-0">';
			foreach( $settings['slides_3'] as $service_slider ){
                echo '<div class="col-md-6 col-lg-4 service-list-wrap">';
                    echo '<div class="service-list">';
                        echo '<div class="service-list_icon">';
                            echo Konta_img_tag( array(
								'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
							) );
                        echo '</div>';
                        echo '<div class="service-list_content">';
                         	if( ! empty( $service_slider['service_title'] ) ){
                            echo '<h3 class="service-list_title box-title"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
                        	}
                        	if( ! empty( $service_slider['service_description'] ) ){
                        		echo '<p class="service-list_text">';
                            		echo wp_kses_post( $service_slider['service_description'] );
                            	echo '</p>';
                            }
                            echo '<a href="'.esc_url( $service_slider['button_url'] ).'" class="service-list_btn"><span class="icon-btn"><i class="fas fa-arrow-right"></i></span>'.esc_html( $service_slider['button_text'] ).'</a>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            }
            echo '</div>';
		}else{
			echo '<div class="row slider-shadow th-carousel" data-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-xs-slide-show="1" data-arrows="true">';
				foreach( $settings['slides'] as $service_slider ){
	                echo '<div class="col-md-6 col-lg-4">';
	                    echo '<div class="service-box style2">';
	                    	if( ! empty( $service_slider['service_slider_image']['url'] ) ){
		                        echo '<div class="service-box_img">';
		                            echo konta_img_tag( array(
										'url'   => esc_url( $service_slider['service_slider_image']['url'] ),
									) );
		                        echo '</div>';
		                    }

	                        echo '<div class="service-box_content">';
	                        	if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
		                            echo '<div class="service-box_bg-icon">';
		                                echo konta_img_tag( array(
											'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
										) );
		                            echo '</div>';
		                        }
		                        if( ! empty( $service_slider['service_slider_icon_image']['url'] ) ){
		                            echo '<div class="service-box_icon">';
		                                echo konta_img_tag( array(
											'url'   => esc_url( $service_slider['service_slider_icon_image']['url'] ),
										) );
		                            echo '</div>';
		                        }
		                        if( ! empty( $service_slider['tag'] ) ){
		                            echo '<span class="service-box_subtitle">'.esc_html( $service_slider['tag'] ).'</span>';
		                        }

	                            if( ! empty( $service_slider['service_title'] ) ){
		                            echo '<h3 class="box-title"><a href="'.esc_url( $service_slider['button_url'] ).'">'.esc_html( $service_slider['service_title'] ).'</a></h3>';
		                        }
		                        if( ! empty( $service_slider['service_description'] ) ){
		                            echo '<p class="service-box_text">'.esc_html( $service_slider['service_description'] ).'</p>';
		                        }
	                        echo '</div>';
	                        if( ! empty( $service_slider['button_text'] ) ){
		                        echo '<a href="'.esc_url( $service_slider['button_url'] ).'" class="service-box_btn">'.esc_html( $service_slider['button_text'] ).'<i class="fas fa-arrow-right"></i></a>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';

		}
		

	}

}

