<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Konta_Play_Button_2 extends Widget_Base {

	public function get_name() {
		return 'drillerplaybutton';
	}

	public function get_title() {
		return __( 'Play Button v2', 'Konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'Konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'play_button_section',
			[
				'label' 	=> __( 'Play Button', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'video_link',
			[
				'label' 		=> __( 'Video Url', 'Konta' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
                'default' 		=> __('#','Konta'),
                'placeholder' 	=> __( 'https://your-link.com', 'Konta' ),

			]
        );	
        $this->end_controls_section();

        $this->start_controls_section(
			'video_btn_style_section',
			[
				'label' 	=> __( 'Video Button Style', 'Konta' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'video_btn_color',
			[
				'label' 	=> __( 'Video Button Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn > i' => '--white-color: {{VALUE}};',
                ]
			]
        );
        $this->add_control(
			'video_btn_bg_color',
			[
				'label' 	=> __( 'Button Background Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn > i' => '--theme-color: {{VALUE}};',
                ]
			]
        );
        $this->add_control(
			'video_btn_bg_hvr_color',
			[
				'label' 	=> __( 'Button Background Hover Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn > i' => '--title-color: {{VALUE}};',
                ]
			]
        );
        $this->add_control(
			'video_btn_bg_rapple_color',
			[
				'label' 	=> __( 'Button Rapple Color', 'Konta' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .play-btn::after' => '--title-color: {{VALUE}};',
                ]
			]
        );
        $this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<a href="'.esc_url($settings['video_link']).'" class="play-btn style3 popup-video"><i class="fas fa-play"></i></a>';
	}

}

