<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Project Box Widget .
 *
 */
class Konta_Project extends Widget_Base {

	public function get_name() {
		return 'kontaproject';
	}

	public function get_title() {
		return __( 'Konta Project', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'project_section',
			[
				'label' 	=> __( 'Project', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Project Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style Four', 'konta' ),
					'layout_five'  		=> __( 'Style Five', 'konta' ),
				]
			]
		);
		
        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Project Title' , 'konta' ),
			]
        );
        $repeater->add_control(
			'desc',
			[
				'label'     => __( 'Description', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'icon',
			[
				'label' 		=> __( 'Choose Icon', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'details_page',
			[
				'label'     => __( 'Single Page URL', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'btn_txt',
			[
				'label'     => __( 'Button Text', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Read More' , 'konta' ),
			]
        );
        $this->add_control(
			'projects',
			[
				'label' 		=> __( 'Projects', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				'condition'		=> [ 'layout_style' => ['layout_one', 'layout_five']],
			]
		);

        //--------------------------------------style two--------------------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Project Title' , 'konta' ),
			]
        );
        $repeater->add_control(
			'cat',
			[
				'label'     => __( 'Category', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Category' , 'konta' ),
			]
        );
        $repeater->add_control(
			'details_page',
			[
				'label'     => __( 'Single Page URL', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );

        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'projects2',
			[
				'label' 		=> __( 'Projects', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				'condition'		=> [ 'layout_style' =>  'layout_two' ],
			]
		);

		//--------------------------------------style three--------------------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Project Title' , 'konta' ),
			]
        );
        $repeater->add_control(
			'cat',
			[
				'label'     => __( 'Category', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Category' , 'konta' ),
			]
        );
        $repeater->add_control(
			'desc',
			[
				'label'     => __( 'Description', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
			]
        );
        $repeater->add_control(
			'details_page',
			[
				'label'     => __( 'Single Page URL', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );

        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'projects3',
			[
				'label' 		=> __( 'Projects', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				'condition'		=> [ 'layout_style' =>  'layout_three' ],
			]
		);
		$this->add_control(
			'make_slider',
			[
				'label' 		=> __( 'Make it slider?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> ['layout_style' => ['layout_one', 'layout_five']]
			]
		);

		//--------------------------------------style four--------------------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Project Title' , 'konta' ),
			]
        );
        $repeater->add_control(
			'location',
			[
				'label'     => __( 'Location', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default' 		=> __( 'Project Title' , 'konta' ),
			]
        );
        $repeater->add_control(
			'details_page',
			[
				'label'     => __( 'Single Page URL', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );

        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->add_control(
			'projects4',
			[
				'label' 		=> __( 'Projects', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				'condition'		=> [ 'layout_style' =>  'layout_four' ],
			]
		);

		
		$this->add_control(
			'shape',
			[
				'label' 		=> __( 'Shape Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'		=> [ 'layout_style' => ['layout_one', 'layout_five']],
			]
		);

        $this->end_controls_section();

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector, {{WRAPPER}} .project-card.style3 .project-card-details-wrap .box-title a, {{WRAPPER}} .project-card.style2 .project-card-details .box-title a, {{WRAPPER}} .project-card.style5 .box-title a',['layout_one', 'layout_five', 'layout_two', 'layout_three', 'layout_four'] );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Description Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Description', '{{WRAPPER}} .desc-selector',['layout_one', 'layout_five', 'layout_two', 'layout_three', 'layout_four'] );

        $this->end_controls_section();

        //-------------------------------------cat styling-------------------------------------//

        $this->start_controls_section(
			'section_cat_style_section',
			[
				'label' => __( 'category Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'		=> [ 'layout_style' =>  'layout_three' ],
			]
		);
		konta_all_elementor_style($this, 'Category', '{{WRAPPER}} .cat-selector',['layout_three'] );

        $this->end_controls_section();

        $this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		        'condition'		=> [ 'layout_style' =>  'layout_one', 'layout_five' ],
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn.style9', ['layout_one', 'layout_five']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn.style9', ['layout_one', 'layout_five']);
					konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .th-btn.style9', ['layout_one', 'layout_five'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn.style9', ['layout_one', 'layout_five']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn.style9:hover', ['layout_one', 'layout_five']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn.style9:before, {{WRAPPER}} .th-btn.style9:after', ['layout_one', 'layout_five'], 'background-color');
					konta_elementor_border_style($this, 'Button Hover', '{{WRAPPER}} .th-btn.style9:hover', ['layout_one', 'layout_five']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){
        	if(!empty( $settings['make_slider'])) {
	        	echo '<div class="row th-carousel project-slider-1" data-slide-show="3" data-xl-slide-show="3" data-ml-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-center-mode="true" data-xl-center-mode="true" data-ml-center-mode="true" data-dots="false" data-adaptive-height="true">';
	        	$col = 'col-lg-4 col-xl-3';

	        }else{
	        	echo '<div class="row gy-4">';
	        	$col = 'col-xl-4 col-md-6';

	        }

        		foreach( $settings['projects'] as $data ) {  
	                echo '<div class="'.esc_attr( $col ).'">';
	                    echo '<div class="project-card">';
	                    	if( ! empty( $data['image']['url'] ) ){
		                        echo '<div class="project-card-img">';
		                            echo konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
		                        echo '</div>';
		                    }
		                    if( ! empty( $data['icon']['url'] ) ){
		                        echo '<div class="project-card-icon">';
		                            echo konta_img_tag( array(
										'url'   => esc_url( $data['icon']['url'] ),
									) );
		                        echo '</div>';
		                    }

		                    $shape = $settings['shape']['url'] ? $settings['shape']['url'] : '#';


	                        echo '<div class="project-card-details" data-bg-src="'.esc_url( $shape ).'">';

	                        	if( ! empty( $data['title'] ) ){
		                            echo '<h4 class="box-title title-selector"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h4>';
		                        }
		                        if( ! empty( $data['desc'] ) ){
		                            echo '<p class="project-card-content desc-selector">'.esc_html( $data['desc'] ).'</p>';
		                        }
	                            echo '<a href="'.esc_url($data['details_page']).'" class="th-btn style9" tabindex="-1">'.esc_html($data['btn_txt']).' <i class="fas fa-arrow-right ms-1"></i></a>';
	                        echo '</div>';

	                    echo '</div>';
	                echo '</div>';
	            }
                
            echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="container-fluid p-0">';
	            echo '<div class="th-carousel project-slider3" data-slide="1" data-variable-width="true" data-sm-variable-width="false" data-xs-variable-width="false" data-adaptive-height="true" data-arrows="false">';
	            	
	            	foreach( $settings['projects2'] as $data ) { 
	            		
		                echo '<div class="project-card style3">';
		                    if( ! empty( $data['image']['url'] ) ){
		                        echo '<div class="project-card-img">';
		                            echo konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
		                        echo '</div>';
		                    }
		                    echo '<div class="project-card-details-wrap">';
		                        echo '<div class="project-card-details">';
		                        	if( ! empty( $data['cat'] ) ){
			                            echo '<h6 class="project-subtitle desc-selector">'.esc_html( $data['cat'] ).'</h6>';
			                        }
		                            if( ! empty( $data['title'] ) ){
			                            echo '<h4 class="box-title title-selector"><a href="'.esc_url($data['details_page']).'"  tabindex="-1">'.esc_html( $data['title'] ).'</a></h4>';
			                        }
		                        echo '</div>';
		                        echo '<a href="'.esc_url( esc_url( $data['image']['url'] ) ).'" class="icon-btn popup-image"><i class="fa-solid fa-arrow-up-right"></i></a>';
		                    echo '</div>';
		                echo '</div>';
	
		            }
	            echo '</div>';
	        echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="container-fluid">';
	            echo '<div class="row th-carousel project-slider2" data-slide-show="4" data-ml-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">';

	            	foreach( $settings['projects3'] as $data ) { 
		                echo '<div class="col-md-6 col-xl-4">';
		                    echo '<div class="project-card style2">';
		                    	if( ! empty( $data['image']['url'] ) ){
			                        echo '<div class="project-card-img">';
			                            echo konta_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
			                        echo '</div>';
			                    }
		                        echo '<div class="project-card-details-wrap">';
		                            echo '<div class="project-card-details">';
		                            	if( ! empty( $data['cat'] ) ){
				                            echo '<h6 class="project-subtitle cat-selector">'.esc_html( $data['cat'] ).'</h6>';
				                        }
				                        if( ! empty( $data['title'] ) ){
				                            echo '<h4 class="box-title title-selector"><a href="'.esc_url($data['details_page']).'"  tabindex="-1">'.esc_html( $data['title'] ).'</a></h4>';
				                        }
				                        if( ! empty( $data['desc'] ) ){
			                                echo '<p class="project-card-content desc-selector">'.esc_html( $data['desc'] ).'</p>';
			                            }
		                            echo '</div>';
		                            if( ! empty( $data['image']['url'] ) ){
			                            echo '<a href="'.esc_url( esc_url( $data['image']['url'] ) ).'" class="gallery-btn popup-image"><i class="fas fa-plus"></i></a>';
			                        }
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
	            echo '</div>';
	        echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_four' ){
	    	echo '<div class="container-fluid p-0">';
	            echo '<div class="row th-carousel portfolio-slider4 gx-30" data-slide-show="3" data-ml-slide-show="3" data-lg-slide-show="1" data-md-slide-show="1" data-sm-slide-show="1" data-dots="true" data-xl-dots="true" data-ml-dots="true" data-lg-dots="true" data-md-dots="true" data-center-mode="true" data-xl-center-mode="true" data-ml-center-mode="true" data-arrows="false">';

	                $i = 0;
	        		foreach( $settings['projects4'] as $data ) {  
	        			$i++;
						$k = str_pad($i, 2, '0', STR_PAD_LEFT);
		                echo '<div class="col-lg-3">';
		                    echo '<div class="project-card style5">';
		                        if( ! empty( $data['image']['url'] ) ){
			                        echo '<div class="project-card-img">';
			                            echo konta_img_tag( array(
											'url'   => esc_url( $data['image']['url'] ),
										) );
			                        echo '</div>';
			                    }
		                        echo '<div class="project-card-details-wrap">';
		                            echo '<div class="project-card-details">';
		                            	if( ! empty( $data['title'] ) ){
				                            echo '<h4 class="box-title title-selector"><a href="'.esc_url($data['details_page']).'"  tabindex="-1">'.esc_html( $data['title'] ).'</a></h4>';
				                        }
				                        if( ! empty( $data['location'] ) ){
			                                echo '<p class="project-location desc-selector"><i class="fa-regular fa-location-dot"></i>'.esc_html( $data['location'] ).'</p>';
			                            }
		                            echo '</div>';
		                            echo '<div class="project-card-number">'.esc_html($k).' </div>';
		                                
		                        echo '</div>';
		                    echo '</div>';
		                echo '</div>';
		            }
	            echo '</div>';
	        echo '</div>';
	    }else{
	    	if(!empty( $settings['make_slider'])) {
	        	echo '<div class="row th-carousel project-slider-1" data-slide-show="3" data-xl-slide-show="3" data-ml-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-center-mode="true" data-xl-center-mode="true" data-ml-center-mode="true" data-dots="false" data-adaptive-height="true">';
	        	$col = 'col-lg-4 col-xl-3';
	        }else{
	        	echo '<div class="row gy-4">';
	        	$col = 'col-xl-4 col-md-6';
	        }

        		foreach( $settings['projects'] as $data ) {  
	                echo '<div class="'.esc_attr( $col ).'">';
	                	echo '<div class="project-card style1-1">';
	                        if( ! empty( $data['image']['url'] ) ){
		                        echo '<div class="project-card-img">';
		                            echo konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
		                        echo '</div>';
		                    }
		                    $shape = $settings['shape']['url'] ? $settings['shape']['url'] : '#';
	                        echo '<div class="project-card-details" data-bg-src="'.esc_url( $shape ).'">';
	                            if( ! empty( $data['title'] ) ){
		                            echo '<h4 class="box-title title-selector"><a href="'.esc_url($data['details_page']).'">'.esc_html( $data['title'] ).'</a></h4>';
		                        }
	                            if( ! empty( $data['desc'] ) ){
		                            echo '<p class="project-card-content desc-selector">'.esc_html( $data['desc'] ).'</p>';
		                        }
	                            echo '<a href="'.esc_url($data['details_page']).'" class="th-btn style9" tabindex="-1">'.esc_html($data['btn_txt']).' <i class="fas fa-arrow-right ms-1"></i></a>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
                
            echo '</div>';
	    }
	}
}