<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Skill Widget .
 *
 */
class konta_Skill extends Widget_Base {

	public function get_name() {
		return 'kontaskill';
	}
	public function get_title() {
		return __( 'Skill Bar', 'konta' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'konta' ];
	}

	protected function register_controls() {

        $this->start_controls_section(
                'skill_bar_section',
                    [
                        'label' 	=> __( 'Skill Bar', 'konta' ),
                        'tab' 		=> Controls_Manager::TAB_CONTENT,
                    ]
        );

        $this->add_control(
                'layout_style',
                [
                    'label' 	=> __( 'Layout Style', 'konta' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'default' 	=> '1',
                    'options' 	=> [
                        '1'  		=> __( 'Style One', 'konta' ),
                    ],
                ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'skill_title',
                [
                'label'         => __( 'Title', 'konta' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => __( 'Skill' , 'konta' ),
                'label_block'   => true,
                ]
        );

        $repeater->add_control(
            'skill_num',
                [
                'label'         => __( 'Number', 'konta' ),
                'type'          => Controls_Manager::TEXT,
                'default'       => __( '90' , 'konta' ),
                'label_block'   => true,
                ]
        );

        $this->add_control(
            'skill_lists',
            [
                'label' 		=> __( 'Skill Lists', 'konta' ),
                'type' 			=> Controls_Manager::REPEATER,
                'fields' 		=> $repeater->get_controls(),
                'default' 		=> [
                        [
                            'skill_title' 		=> __( 'Title', 'konta' ),
                        ],
                ],
            ]
        );

        $this->end_controls_section();

    //---------------------------------------
        //Style Section Start
    //---------------------------------------

	//-------------------------General Style-----------------------//
    $this->start_controls_section(
        'general_section',
        [
            'label' => __( 'General Style', 'konta' ),
            'tab' 	=> Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control(
        'general_color',
        [
            'label' 	=> __( 'Bar Color', 'konta' ),
            'type' 		=> Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress-bar' => '--theme-color: {{VALUE}}!important;',
            ],
        ]
    );

    $this->end_controls_section();

	//-------------------------Content Style-----------------------//
    $this->start_controls_section(
        'content_style_section',
        [
            'label' => __( 'Content Style', 'konta' ),
            'tab' 	=> Controls_Manager::TAB_STYLE,
        ]
    );

    $this->add_control(
        'content_color',
        [
            'label' 	=> __( 'Label Color', 'konta' ),
            'type' 		=> Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .th-title' => 'color: {{VALUE}}!important;',
            ],
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' 		=> 'content_typography',
            'label' 	=> __( 'Label Typography', 'konta' ),
            'selector' 	=> '{{WRAPPER}} .th-title',
        ]
    );

    $this->add_control(
        'content_color2',
        [
            'label' 	=> __( 'Number Color', 'konta' ),
            'type' 		=> Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .progress-value' => 'color: {{VALUE}}!important;',
            ],
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' 		=> 'content_typography2',
            'label' 	=> __( 'Number Typography', 'konta' ),
            'selector' 	=> '{{WRAPPER}} .progress-value',
        ]
    );

    $this->end_controls_section();


	}

	protected function render() {

    $settings = $this->get_settings_for_display();

        foreach( $settings['skill_lists'] as $data ) {
            echo '<div class="skill-feature style3">';
                echo '<h3 class="skill-feature_title">'.esc_html($data['skill_title']).'</h3>';
                echo '<div class="progress">';
                    echo '<div class="progress-bar" style="width: '.esc_attr($data['skill_num']).'%;"></div>';
                    echo '<div class="progress-value">'.esc_attr($data['skill_num']).'%</div>';
                echo '</div>';
            echo '</div>';
        }

	}

}