<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Team Box Widget .
 *
 */
class Konta_Team extends Widget_Base {

	public function get_name() {
		return 'kontateam';
	}

	public function get_title() {
		return __( 'Konta Team', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'team_section',
			[
				'label' 	=> __( 'Team', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Team Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style Four', 'konta' ),
					'layout_five'  		=> __( 'Style Five', 'konta' ),
				]
			]
		);
		$this->add_control(
			'title', [
				'label' 		=> __( 'Title', 'konta' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Title' , 'konta' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		$this->add_control(
			'subtitle', [
				'label' 		=> __( 'Subtitle', 'konta' ),
				'type' 			=> \Elementor\Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Subtitle' , 'konta' ),
				'rows' 			=> 2,
				'label_block' 	=> true,
				'condition'	=> ['layout_style' => ['layout_four']]
			]
		);
		$this->add_control(
			'make_slider',
			[
				'label' 		=> __( 'Make it slider?', 'konta' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'konta' ),
				'label_off' 	=> __( 'Hide', 'konta' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> ['layout_style' => ['layout_two']]
			]
		);
		
        $this->end_controls_section();




	    include konta_get_elementor_option('team-one-options.php');
	    include konta_get_elementor_option('team-two-options.php');

	

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Name', '{{WRAPPER}} .title-selector a',['layout_one', 'layout_two' , 'layout_three', 'layout_four'] );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Designation Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Designation', '{{WRAPPER}} .desig-selector',['layout_one', 'layout_two' , 'layout_three', 'layout_four'] );

        $this->end_controls_section();


         //-------------------------------------section title styling-------------------------------------//

        $this->start_controls_section(
			'section_title1_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['layout_style' => ['layout_four']]

			]
		);
		konta_all_elementor_style($this, 'Section Title', '{{WRAPPER}} .sec-title',['layout_four'] );

        $this->end_controls_section();


        //-------------------------------------section subtitle styling-------------------------------------//
       

        $this->start_controls_section(
			'section_sub_style_section',
			[
				'label' => __( 'Subtitle Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> ['layout_style' => ['layout_four']]

			]
		);
		konta_all_elementor_style($this, 'Section Subtitle', '{{WRAPPER}} .sub-title4',['layout_four'] );

        $this->end_controls_section();

       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="row th-carousel arrow-style2 arrow-wrap" data-slide-show="4" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="2" data-xs-slide-show="1" data-arrows="true">';

            	foreach( $settings['team_members'] as $data ) {
            		$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

					$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
					$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

					$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
					$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

					$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
					$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';



	                echo '<!-- Single Item -->';
	                echo '<div class="col-lg-6">';
	                    echo '<div class="team-card">';
	                        echo '<div class="team-img-wrap">';
	                        	if( ! empty( $data['team_image']['url'] ) ){
			                        echo '<div class="team-img">';
			                            echo konta_img_tag( array(
				                            'url'       => esc_url( $data['team_image']['url'] ),
				                        ) );
			                        echo '</div>';
			                    }
	                            echo '<div class="th-social">';
	                            	if( ! empty( $data['fb_link']['url']) ){
		                                echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
		                            }
		                            if( ! empty( $data['twitter_link']['url']) ){
		                                echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
		                            }
		                            if( ! empty( $data['linkedin_link']['url']) ){
		                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
		                            }
	                            echo '</div>';
	                        echo '</div>';
	                        echo '<div class="team-content">';
	                        	if( ! empty( $data['name']) ){
			                        echo '<h3 class="team-title box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
			                    }
			                    if( ! empty( $data['designation']) ){
			                        echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
			                    }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';	
	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	if(!empty( $settings['make_slider'])) {
				echo '<div class="row th-carousel slider-shadow" data-slide-show="4" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="2" data-xs-slide-show="1">';
				$col = 'col-lg-6';
			}else{
				echo '<div class="row gy-4">';
				$col = 'col-xl-3 col-lg-4 col-md-6';
			}
	    	

	    		foreach( $settings['team_members'] as $data ) {
            		$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

					$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
					$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

					$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
					$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

					$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
					$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

	                echo '<!-- Single Item -->';
	                echo '<div class="'.esc_attr( $col ).'">';
	                    echo '<div class="team-card style2">';
	                        if( ! empty( $data['team_image']['url'] ) ){
		                        echo '<div class="team-img">';
		                            echo konta_img_tag( array(
			                            'url'       => esc_url( $data['team_image']['url'] ),
			                        ) );
		                        echo '</div>';
		                    }
	                        echo '<div class="team-content">';
	                        	if( ! empty( $data['name']) ){
			                        echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
			                    }
	                            if( ! empty( $data['designation']) ){
			                        echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
			                    }
	                            echo '<div class="team-social">';
	                                echo '<button class="icon-btn"><i class="far fa-plus"></i></button>';
	                                echo '<div class="th-social">';
	                                    if( ! empty( $data['fb_link']['url']) ){
			                                echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
			                            }
			                            if( ! empty( $data['twitter_link']['url']) ){
			                                echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
			                            }
			                            if( ! empty( $data['linkedin_link']['url']) ){
			                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
			                            }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            } 
            echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="row th-carousel slider-shadow arrow-style5 arrow-wrap" data-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-arrows="true">';
                
                foreach( $settings['team_members'] as $data ) {
            		$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

					$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
					$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

					$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
					$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

					$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
					$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

	                echo '<!-- Single Item -->';
	                echo '<div class="col-sm-6 col-lg-4 col-xl-3">';
	                    echo '<div class="team-card style3">';
	                    	if( ! empty( $data['team_image']['url'] ) ){
		                        echo '<div class="team-img">';
		                            echo konta_img_tag( array(
			                            'url'       => esc_url( $data['team_image']['url'] ),
			                        ) );
		                        echo '</div>';
		                    }
	                        echo '<div class="team-content">';
	                        	if( ! empty( $data['name']) ){
			                        echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
			                    }
	                            if( ! empty( $data['designation']) ){
			                        echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
			                    }
	                            echo '<div class="th-social">';
	                                if( ! empty( $data['fb_link']['url']) ){
		                                echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
		                            }
		                            if( ! empty( $data['twitter_link']['url']) ){
		                                echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
		                            }
		                            if( ! empty( $data['linkedin_link']['url']) ){
		                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
		                            }
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_four' ){
	    	echo '<div class="space overflow-hidden">';
		        echo '<div class="container">';
		            echo '<div class="row justify-content-between align-items-center">';
		                echo '<div class="col-md-auto">';
		                    echo '<div class="title-area">';
		                    	if( ! empty( $settings['title'] ) ){
		                            echo '<span class="sub-title4">'.esc_html( $settings['title'] ).'</span>';
		                        }
		                        if( ! empty( $settings['subtitle'] ) ){
		                            echo '<h2 class="sec-title fw-semibold">'.esc_html( $settings['subtitle'] ).'</h2>';
		                        }
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-md-auto">';
		                    echo '<div class="icon-box arrow-style7 mb-40">';
		                        echo '<button data-slick-prev=".team-slider4" class="slick-arrow default"><i class="far fa-arrow-left"></i></button>';
		                        echo '<button data-slick-next=".team-slider4" class="slick-arrow default"><i class="far fa-arrow-right"></i></button>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';

		            echo '<div class="team-slider4 row th-carousel slider-shadow arrow-style5" data-slide-show="4" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-arrows="false">';

		            	foreach( $settings['team_members'] as $data ) {
		            		$target = $data['profile_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $data['profile_link']['nofollow'] ? ' rel="nofollow"' : '';

							$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
							$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

							$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
							$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

							$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
							$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';

			                echo '<!-- Single Item -->';
			                echo '<div class="col-sm-6 col-lg-4 col-xl-3">';
			                    echo '<div class="team-card style4">';
			                        if( ! empty( $data['team_image']['url'] ) ){
				                        echo '<div class="team-img">';
				                            echo konta_img_tag( array(
					                            'url'       => esc_url( $data['team_image']['url'] ),
					                        ) );
				                        echo '</div>';
				                    }
			                        echo '<div class="team-content">';
			                            if( ! empty( $data['name']) ){
					                        echo '<h3 class="box-title title-selector"><a '.wp_kses_post( $nofollow.$target ).' href="'.esc_url( $data['profile_link']['url'] ).'">'.esc_html($data['name']).'</a></h3>';
					                    }
			                            if( ! empty( $data['designation']) ){
					                        echo '<span class="team-desig desig-selector">'.esc_html($data['designation']).'</span>';
					                    }
			                            echo '<div class="team-social">';
			                                echo '<button class="icon-btn"><i class="far fa-plus"></i></button>';
			                                echo '<div class="th-social">';
			                                    if( ! empty( $data['fb_link']['url']) ){
					                                echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
					                            }
					                            if( ! empty( $data['twitter_link']['url']) ){
					                                echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
					                            }
					                            if( ! empty( $data['linkedin_link']['url']) ){
					                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
					                            }
			                            	echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		   echo ' </div>';
	    }else{
	    	echo '<div class="team-tab">';
                echo '<div class="row flex-row-reverse">';
                    echo '<div class="col-lg-6 align-self-center">';
                        echo '<ul class="team-tab-wrap" id="tabs-nav">';
                        	$i = 0;
                        	foreach( $settings['team_members2'] as $data ) {
                        		$i++;


								$f_target = $data['fb_link']['is_external'] ? ' target="_blank"' : '';
								$f_nofollow = $data['fb_link']['nofollow'] ? ' rel="nofollow"' : '';

								$t_target = $data['twitter_link']['is_external'] ? ' target="_blank"' : '';
								$t_nofollow = $data['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';

								$l_target = $data['linkedin_link']['is_external'] ? ' target="_blank"' : '';
								$l_nofollow = $data['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';
	                            echo '<li>';
	                                echo '<div class="team-tab-item" data-bs-toggle="tab" data-bs-target="#tab'.esc_attr( $i ).'">';
	                                    echo '<div class="team-card style5">';
	                                        echo '<div class="team-img-wrap">';
	                                        	if( ! empty( $data['team_image']['url'] ) ){
							                        echo '<div class="team-img">';
							                            echo konta_img_tag( array(
								                            'url'       => esc_url( $data['team_image']['url'] ),
								                        ) );
							                        echo '</div>';
							                    }
	                                            echo '<div class="th-social">';
	                                                if( ! empty( $data['fb_link']['url']) ){
						                                echo '<a '.wp_kses_post( $f_nofollow.$f_target ).' href="'.esc_url( $data['fb_link']['url'] ).'"><i class="fab fa-facebook-f"></i></a>';
						                            }
						                            if( ! empty( $data['twitter_link']['url']) ){
						                                echo '<a '.wp_kses_post( $t_nofollow.$t_target ).' href="'.esc_url( $data['twitter_link']['url'] ).'"><i class="fab fa-twitter"></i></a>';
						                            }
						                            if( ! empty( $data['linkedin_link']['url']) ){
						                                echo '<a '.wp_kses_post( $l_nofollow.$l_target ).' href="'.esc_url( $data['linkedin_link']['url'] ).'"><i class="fab fa-linkedin-in"></i></a>';
						                            }
	                                            echo '</div>';
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</li>';
	                        }
                        echo '</ul>';
                    echo '</div>';
                    echo '<div class="col-lg-6">';
                        echo '<div id="tabs-content">';
                        	$i = 0;
                            foreach( $settings['team_members2'] as $data ) {
                            	$i++;
	                            echo '<div id="tab'.esc_attr( $i ).'" class="team-tab-content">';
	                            	if( ! empty( $data['name']) ){
				                        echo '<h3 class="team-tab-title title-selector">'.esc_html($data['name']).'</h3>';
				                    }
	                                if( ! empty( $data['designation']) ){
				                        echo '<span class="team-tab-desig desig-selector">'.esc_html($data['designation']).'</span>';
				                    }
	                                if( ! empty( $data['desc']) ){
		                                echo '<p class="mb-30">'.wp_kses_post($data['desc']).'</p>';
		                            }
		                            if( ! empty( $data['exp_label']) ){
		                                echo '<h4 class="team-tab-subtitle">'.esc_html($data['exp_label']).'</h4>';
		                            }

	                                echo '<div class="skill-feature style2">';
	                                	if( ! empty( $data['exp_title']) ){
		                                    echo '<h3 class="skill-feature_title">'.esc_html($data['exp_title']).'</h3>';
		                                }
		                                if( ! empty( $data['exp_number']) ){
		                                    echo '<div class="progress">';
		                                        echo '<div class="progress-bar" style="width: '.esc_attr($data['exp_number']).'%;"></div>';
		                                        echo '<div class="progress-value">'.esc_html($data['exp_number']).'%</div>';
		                                    echo '</div>';
		                                }
	                                echo '</div>';
	                                echo '<div class="skill-feature style2">';
	                                	if( ! empty( $data['exp_title_2']) ){
		                                    echo '<h3 class="skill-feature_title">'.esc_html($data['exp_title_2']).'</h3>';
		                                }
		                                if( ! empty( $data['exp_number_2']) ){
		                                    echo '<div class="progress">';
		                                        echo '<div class="progress-bar" style="width: '.esc_attr($data['exp_number_2']).'%;"></div>';
		                                        echo '<div class="progress-value">'.esc_html($data['exp_number_2']).'%</div>';
		                                    echo '</div>';
		                                }
	                                echo '</div>';
	                            echo '</div>';
	                        }
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
	    }
	}
}