<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Testimonials Box Widget .
 *
 */
class Konta_Testimonials extends Widget_Base {

	public function get_name() {
		return 'kontatstimonials';
	}

	public function get_title() {
		return __( 'Konta Testimonials', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'team_section',
			[
				'label' 	=> __( 'Testimonials', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Testimonials Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
					'layout_three'  	=> __( 'Style Three', 'konta' ),
					'layout_four'  		=> __( 'Style Four', 'konta' ),
					'layout_five'  		=> __( 'Style Five', 'konta' ),
				]
			]
		);
		$this->add_control(
			'quote',
			[
				'label'     => __( 'Quote Shape', 'konta' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'	=> ['layout_style!' => ['layout_four']]
			]
		);
		
        $this->end_controls_section();




	    include konta_get_elementor_option('testimonial-one-options.php');
	    include konta_get_elementor_option('testimonial-two-options.php');

	

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one', 'layout_two' , 'layout_three'] );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Feedback Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Feedback', '{{WRAPPER}} .desc-selector',['layout_one', 'layout_two' , 'layout_three'] );

        $this->end_controls_section();


	//-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desig_style_section',
			[
				'label' => __( 'Designation Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Designation', '{{WRAPPER}} .desig-selector',['layout_one', 'layout_two' , 'layout_three'] );

        $this->end_controls_section();

       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="row arrow-wrap">';
                echo '<div class="col-xl-12">';
                    echo '<div class="th-carousel testi-slider1 slider-shadow row" data-slide-show="2" data-ml-slide-show="2" data-lg-slide-show="1" data-md-slide-show="1" data-arrows="true">';
                    	foreach( $settings['1_testimonials'] as $data ) {
	                        echo '<div class="col-lg-6">';
	                            echo '<div class="testi-card">';

	                            	if( ! empty( $data['client_image']['url'] ) ){
				                        echo '<div class="testi-card_img">';
				                            echo konta_img_tag( array(
					                            'url'       => esc_url( $data['client_image']['url'] ),
					                        ) );
				                        echo '</div>';
				                    }
	                                echo '<div class="testi-card_content">';
	                                	if( ! empty( $data['feedback']) ){
		                                    echo '<p class="testi-card_text desc-selector">'.esc_html($data['feedback']).'</p>';
		                                }
	                                    echo '<div class="testi-card_bottom">';
	                                        echo '<div>';
	                                        	if( ! empty( $data['name']) ){
		                                            echo '<h3 class="testi-card_name title-selector">'.esc_html($data['name']).'</h3>';
		                                        }
		                                        if( ! empty( $data['designation']) ){
		                                            echo '<span class="testi-card_desig desig-selector">'.esc_html($data['designation']).'</span>';
		                                        }
	                                        echo '</div>';
	                                        if( ! empty( $settings['quote']['url'] ) ){
		                                        echo '<div class="testi-card_icon">';
		                                            echo konta_img_tag( array(
							                            'url'       => esc_url( $settings['quote']['url'] ),
							                        ) );
		                                        echo '</div>';
		                                    }
	                                    echo '</div>';
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_two' ){
	    	echo '<div class="row testi-slider2 th-carousel arrow-style4" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="1" data-arrows="true" data-adaptive-height="true">';
	    		foreach( $settings['2_testimonials'] as $data ) {
	                echo '<div class="col-lg-6">';
	                    echo '<div class="testi-card style2">';
	                    	if( ! empty( $settings['quote']['url'] ) ){
                                echo '<div class="testi-card_icon">';
                                    echo konta_img_tag( array(
			                            'url'       => esc_url( $settings['quote']['url'] ),
			                        ) );
                                echo '</div>';
                            }
                            if( ! empty( $data['feedback']) ){
		                        echo '<p class="testi-card_text desc-selector"><span class="text-theme">“</span> '.esc_html($data['feedback']).' <span class="text-theme">”</span></p>';
		                    }
	                        echo '<div class="testi-card_content">';
	                        	if( ! empty( $data['client_image']['url'] ) ){
			                        echo '<div class="testi-card_img">';
			                            echo konta_img_tag( array(
				                            'url'       => esc_url( $data['client_image']['url'] ),
				                        ) );
			                        echo '</div>';
			                    }
	                            echo '<div class="testi-card_bottom">';
	                            	if( ! empty( $data['name']) ){
                                        echo '<h3 class="testi-card_name title-selector">'.esc_html($data['name']).'</h3>';
                                    }
                                    if( ! empty( $data['designation']) ){
                                        echo '<span class="testi-card_desig desig-selector">'.esc_html($data['designation']).'</span>';
                                    }
	                                echo '<div class="testi-card_review">';
	                                	if( $data['client_rating'] == 'one' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'two' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'three' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'four' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }else{
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_three' ){
	    	echo '<div class="row slider-shadow th-carousel arrow-style6 testi-slider3 arrow-wrap" data-slide-show="3" data-ml-slide-show="2" data-lg-slide-show="2" data-md-slide-show="1" data-arrows="true" data-xl-arrows="true" data-ml-arrows="true">';
                foreach( $settings['2_testimonials'] as $data ) {
	                echo '<div class="col-lg-6">';
	                    echo '<div class="testi-card style3">';
	                    	if( ! empty( $settings['quote']['url'] ) ){
		                        echo '<div class="testi-card-icon">';
		                            echo konta_img_tag( array(
			                            'url'       => esc_url( $settings['quote']['url'] ),
			                        ) );
		                        echo '</div>';
		                    }
		                    if( ! empty( $data['feedback']) ){
		                        echo '<p class="testi-card_text desc-selector"><span class="text-theme">“</span> '.esc_html($data['feedback']).' <span class="text-theme">”</span></p>';
		                    }
	                        echo '<div class="testi-card_content">';
	                        	if( ! empty( $data['client_image']['url'] ) ){
			                        echo '<div class="testi-card_img">';
			                            echo konta_img_tag( array(
				                            'url'       => esc_url( $data['client_image']['url'] ),
				                        ) );
			                        echo '</div>';
			                    }
	                            echo '<div class="testi-card_bottom">';
	                            	if( ! empty( $data['name']) ){
                                        echo '<h3 class="testi-card_name title-selector">'.esc_html($data['name']).'</h3>';
                                    }

	                                if( ! empty( $data['designation']) ){
                                        echo '<span class="testi-card_desig desig-selector">'.esc_html($data['designation']).'</span>';
                                    }
	                                echo '<div class="testi-card_review">';
	                                    if( $data['client_rating'] == 'one' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'two' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'three' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'four' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }else{
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
	    }elseif( $settings['layout_style'] == 'layout_four' ){
	    	echo '<div class="row testi-slider4 th-carousel arrow-style4" data-slide-show="1" data-arrows="true" data-xl-arrows="true" data-ml-arrows="true" data-lg-arrows="true" data-md-arrows="true" data-adaptive-height="true">';
                foreach( $settings['2_testimonials'] as $data ) {            
	                echo '<div class="col-lg-6">';
	                    echo '<div class="testi-card style4">';
	                    	if( ! empty( $data['feedback']) ){
		                        echo '<p class="testi-card_text">'.esc_html($data['feedback']).'</p>';
		                    }
	                        echo '<div class="testi-card_content">';
	                            if( ! empty( $data['client_image']['url'] ) ){
			                        echo '<div class="testi-card_img">';
			                            echo konta_img_tag( array(
				                            'url'       => esc_url( $data['client_image']['url'] ),
				                        ) );
			                        echo '</div>';
			                    }
	                            echo '<div class="testi-card_bottom">';
	                                if( ! empty( $data['name']) ){
                                        echo '<h3 class="testi-card_name title-selector">'.esc_html($data['name']).'</h3>';
                                    }
	                                if( ! empty( $data['designation']) ){
                                        echo '<span class="testi-card_desig desig-selector">'.esc_html($data['designation']).'</span>';
                                    }
	                                echo '<div class="testi-card_review">';
	                                    if( $data['client_rating'] == 'one' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'two' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'three' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }elseif( $data['client_rating'] == 'four' ){
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-light fa-star-sharp"></i>';
						                }else{
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                	echo '<i class="fa-regular fa-star-sharp"></i>';
						                }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
                
            echo '</div>';
	    }else{
	    	echo '<div class="testi5-slider-wrap">';
                echo '<div class="testi5-thumb-indicator th-carousel row g-0" data-slide-show="5" data-md-slide-show="5" data-sm-slide-show="3" data-center-mode="true" data-xl-center-mode="true" data-ml-center-mode="true" data-lg-center-mode="true" data-md-center-mode="true" data-sm-center-mode="true" id="testiIndicator-1" data-asnavfor=".testi-slider5">';

                	foreach( $settings['2_testimonials'] as $data ) {  

                		if( ! empty( $data['client_image']['url'] ) ){
	                        echo '<div class="testi5-thumb">';
	                            echo konta_img_tag( array(
		                            'url'       => esc_url( $data['client_image']['url'] ),
		                        ) );
	                        echo '</div>';
	                    }  
	                }
                    
                echo '</div>';
                echo '<div class="row th-carousel arrow-style8 testi-slider5" data-slide-show="1" data-arrows="true" data-xl-arrows="true" data-ml-arrows="true" data-adaptive-height="true" data-asnavfor="#testiIndicator-1">';

                    foreach( $settings['2_testimonials'] as $data ) {  
	                    echo '<div class="col-lg-12">';
	                        echo '<div class="testi-card style5">';
	                        	if( ! empty( $data['name']) ){
                                    echo '<h3 class="testi-card_name title-selector">'.esc_html($data['name']).'</h3>';
                                }

	                            if( ! empty( $data['designation']) ){
                                    echo '<span class="testi-card_desig desig-selector">'.esc_html($data['designation']).'</span>';
                                }
	                            if( ! empty( $data['feedback']) ){
			                        echo '<p class="testi-card_text">'.esc_html($data['feedback']).'</p>';
			                    }
	                            echo '<div class="testi-card_review">';
	                               if( $data['client_rating'] == 'one' ){
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                }elseif( $data['client_rating'] == 'two' ){
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                }elseif( $data['client_rating'] == 'three' ){
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                }elseif( $data['client_rating'] == 'four' ){
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-light fa-star-sharp"></i>';
					                }else{
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                	echo '<i class="fa-regular fa-star-sharp"></i>';
					                }
	                            echo '</div>';
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
	    }
	}
}