<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Box Widget .
 *
 */
class Konta_WCU extends Widget_Base {

	public function get_name() {
		return 'kontawcu';
	}

	public function get_title() {
		return __( 'WCU', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'wcu_section',
			[
				'label' 	=> __( 'WCU', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Wcu Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
				],
			]
		);
		$this->end_controls_section();

		include konta_get_elementor_option('wcu-one-option.php');
		include konta_get_elementor_option('wcu-two-options.php');
		


        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector',['layout_one'],'--white-color' );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Subtitle Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Subtitle', '{{WRAPPER}} .desc-selector',['layout_one'],'--white-color' );

        $this->end_controls_section();

        //-------------------------------------features  styling-------------------------------------//

        $this->start_controls_section(
			'features_style_section',
			[
				'label' => __( 'Features Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Features', '{{WRAPPER}} .wcu-box .box-title',['layout_one'] );
		konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .wcu-box', ['layout_one'], 'background');

        $this->end_controls_section();

        //-------------------------Button Style-----------------------//
		
		$this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'First Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn.style6', ['layout_one']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn.style6', ['layout_one']);
					konta_elementor_color_style($this, 'Button Background', '{{WRAPPER}} .th-btn.style6', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn.style6', ['layout_one']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn.style6:hover', ['layout_one']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn.style6:before, {{WRAPPER}} .th-btn.style6:after', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Buttonn-Hover', '{{WRAPPER}} .th-btn.style6:hover', ['layout_one']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();

		//-------------------------Button Style 2-----------------------//
		
		$this->start_controls_section(
		    'button_style_section2',
		    [
		        'label' => __( '2nd Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button 2', '{{WRAPPER}} .th-btn.style2', ['layout_one']);

			$this->start_controls_tabs(
			    'style_tabs2'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab2',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button 2 Text', '{{WRAPPER}} .th-btn.style2', ['layout_one']);
					konta_elementor_color_style($this, 'Background 2', '{{WRAPPER}} .th-btn.style2', ['layout_one'], 'background-color');
					// konta_elementor_border_style($this, 'Button 2', '{{WRAPPER}} .th-btn.style2', ['layout_one']);
					konta_elementor_border_style($this, 'Buttonn', '{{WRAPPER}} .th-btn.style2', ['layout_one']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab2',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, '2nd Button Text Hover', '{{WRAPPER}} .th-btn.style2:hover', ['layout_one']);
					konta_elementor_color_style($this, '2nd Background Hover', '{{WRAPPER}} .th-btn.style2:before, {{WRAPPER}} .th-btn.style2:after', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Button-Hover', '{{WRAPPER}} .th-btn.style2:hover', ['layout_one']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if( $settings['layout_style'] == 'layout_one' ){
	        echo '<div class="why-area-1 overflow-hidden">';
		        echo '<div class="container">';
		            echo '<div class="row flex-xl-row flex-column-reverse">';
		                echo '<div class="col-xl-10">';
		                    echo '<div class="wcu-wrap1 bg-theme" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/why-bg-1.png">';
		                        echo '<div class="title-area mb-25">';
		                        	if(!empty($settings['title'])){
		                                echo '<span class="sub-title text-white title-selector">';
			                                if(!empty($settings['title_img']['url'])){
							                    echo konta_img_tag( array(
						                        	'url' => esc_url( $settings['title_img']['url'] ),
						                        ) );
							                }
			                                echo esc_html($settings['title']);
		                                echo '</span>';
		                            }
		                            if(!empty($settings['subtitle'])){
			                            echo '<h2 class="sec-title text-white desc-selector">'.esc_html($settings['subtitle']).'</h2>';
			                        }
		                        echo '</div>';
		                        echo '<div class="row gy-4">';

		                        	foreach( $settings['wcus'] as $data ) {   
			                            echo '<div class="col-lg-6">';
			                                echo '<div class="wcu-box">';
			                                	if( ! empty( $data['image']['url'] ) ){
									                echo '<div class="wcu-box_icon">';
									                    echo konta_img_tag( array(
															'url'   => esc_url( $data['image']['url'] ),
														) );
									                echo '</div>';
									            }
									            if( ! empty( $data['title'] ) ){
									            	echo '<div class="wcu-box_details">';
								                    	echo '<h3 class="box-title">'.esc_html( $data['title'] ).'</h3>';
								                    echo '</div>';
								                }
			                                echo '</div>';
			                            echo '</div>';
			                        }
		                            
		                        echo '</div>';
		                        echo '<div class="btn-group mt-40">';
		                        	if(!empty($settings['button_text'])){
			                            echo '<a href="'.esc_url( $settings['button_link']['url'] ).'" class="th-btn style6">'.esc_html($settings['button_text']).'<i class="fas fa-arrow-right ms-1"></i></a>';
			                        }
			                        if(!empty($settings['button_text2'])){
			                            echo '<a href="'.esc_url( $settings['button_link2']['url'] ).'" class="th-btn style2">'.esc_html($settings['button_text2']).'<i class="fas fa-arrow-right ms-1"></i></a>';
			                        }
		                        echo '</div>';
		                        if(!empty( $settings['video_link']['url'] )){
			                        echo '<div class="video-wrap" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/why-bg-1.png">';
			                            echo '<a href="'.esc_url( $settings['video_link']['url'] ).'" class="play-btn style4 popup-video" tabindex="0"><i class="fa-sharp fa-solid fa-play"></i></a>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		                if( ! empty( $settings['banner_img']['url'] ) ){
			                echo '<div class="col-xl-2">';
			                    echo '<div class="wcu-img-1">';
			                        echo '<div class="img1">';
			                            echo konta_img_tag( array(
											'url'   => esc_url( $settings['banner_img']['url'] ),
										) );
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}else{
			echo '<div class="bg-smoke position-relative space">';
				if( ! empty( $settings['2_banner_img']['url'] ) ){
			        echo '<div class="wcu-img-4">';
			            echo konta_img_tag( array(
							'url'   => esc_url( $settings['2_banner_img']['url'] ),
						) );
			            echo '<div class="wcu-grid">';
			                if(!empty($settings['2_exp'])){
	                            echo wp_kses_post($settings['2_exp']);
	                        }
			            echo '</div>';
			        echo '</div>';
			    }
		        echo '<div class="container">';
		            echo '<div class="row">';
		                echo '<div class="col-lg-6">';
		                    echo '<div class="title-area mb-30 text-center text-lg-start">';
		                    	if(!empty($settings['2_title'])){
			                        echo '<span class="sub-title4">'.esc_html( $settings['2_title'] ).'</span>';
			                    }
			                    if(!empty($settings['2_subtitle'])){
			                        echo '<h2 class="sec-title fw-semibold">'.esc_html( $settings['2_subtitle'] ).'</h2>';
			                    }
		                    echo '</div>';
		                    echo '<div class="checklist style8">';
		                        if(!empty($settings['2_desc'])){
		                            echo wp_kses_post($settings['2_desc']);
		                        }

		                    echo '</div>';
		                    echo '<div class="wcu-skill-wrap">';

		                    	foreach( $settings['1_skill'] as $data ) {  
			                        echo '<div class="skill-feature">';
			                        	if(!empty($data['title'])){
				                            echo '<h3 class="skill-feature_title">'.esc_html( $data['title'] ).'</h3>';
				                        }
				                        if(!empty($data['number'])){
				                            echo '<div class="progress">';
				                                echo '<div class="progress-bar" style="width: '.esc_attr( $data['number'] ).'%;">';
				                                echo '</div>';
				                                echo '<div class="progress-value">'.esc_html( $data['number'] ).'%</div>';
				                            echo '</div>';
				                        }
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}