<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Work Box Widget .
 *
 */
class Konta_Work extends Widget_Base {

	public function get_name() {
		return 'kontawork';
	}

	public function get_title() {
		return __( 'Konta Work', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'feature_section',
			[
				'label' 	=> __( 'Work', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Work Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
				],
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'title',
			[
				'label'     => __( 'Title', 'konta' ),
                'type'      => Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
			]
        );
        $repeater->add_control(
			'content',
			[
				'label'     => __( 'Content', 'konta' ),
                'type'      => Controls_Manager::WYSIWYG,
			]
        );
        $repeater->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'konta' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'konta' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Get More Info', 'konta' ),
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'konta' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'konta' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);
        $this->add_control(
			'features',
			[
				'label' 		=> __( 'Works', 'konta' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'title', 'konta' ),
					],
				],
				// 'condition' => [
				// 	'layout_style' => ['layout_one' , 'layout_two']
				// ]
			]
		);
        
        $this->end_controls_section();


        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Title', '{{WRAPPER}} .title-selector, {{WRAPPER}} .title-selector a',['layout_one', 'layout_two' , 'layout_three'] );

        $this->end_controls_section();


        $this->start_controls_section(
		    'button_style_section',
		    [
		        'label' => __( 'Button Style', 'konta' ),
		        'tab'   => Controls_Manager::TAB_STYLE,
		    ]
		);

			konta_elementor_typography_style($this, 'Button', '{{WRAPPER}} .th-btn', ['layout_one']);

			$this->start_controls_tabs(
			    'style_tabs'
			);

				// First Tab: Normal
				$this->start_controls_tab(
				    'first_style_tab',
				    [
				        'label' => esc_html__( 'Normal', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text', '{{WRAPPER}} .th-btn', ['layout_one']);
					konta_elementor_color_style($this, 'Background', '{{WRAPPER}} .th-btn', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Button', '{{WRAPPER}} .th-btn', ['layout_one']);

				$this->end_controls_tab();

				// Second Tab: Hover
				$this->start_controls_tab(
				    'sec_style_tab',
				    [
				        'label' => esc_html__( 'Hover', 'konta' ),
				    ]
				);

					konta_elementor_color_style($this, 'Button Text Hover', '{{WRAPPER}} .th-btn:hover', ['layout_one']);
					konta_elementor_color_style($this, 'Background Hover', '{{WRAPPER}} .th-btn:before, {{WRAPPER}} .th-btn:after', ['layout_one'], 'background-color');
					konta_elementor_border_style($this, 'Button Hover', '{{WRAPPER}} .th-btn:hover', ['layout_one']);

				$this->end_controls_tab();

			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="row gy-4 justify-content-center">';
                foreach( $settings['features'] as $data ) {      
	                echo '<div class="col-md-6 col-xl-4">';
	                    echo '<div class="process-card style2">';
	                    	if( ! empty( $data['image']['url'] ) ){
				                echo '<div class="process-card_img">';
				                    echo konta_img_tag( array(
										'url'   => esc_url( $data['image']['url'] ),
									) );
				                echo '</div>';
				            }
	                        echo '<div class="process-card_details" data-bg-src="'.KONTA_PLUGDIRURI . 'assets/img/process-card-bg1.png">';
	                        	if( ! empty( $data['title'] ) ){
				                    echo '<h4 class="process-card_title title-selector">'.esc_html( $data['title'] ).'</h4>';
				                }
				                if( ! empty( $data['content'] ) ){
		                            echo '<div class="checklist">';
		                              	echo wp_kses_post( $data['content'] );
		                            echo '</div>';
		                        }
		                        if( ! empty( $data['button_text'] ) ){
		                            echo '<a href="'.esc_url($data['button_link']['url']).'" class="th-btn style10">'.esc_html($data['button_text']).' <i class="fas fa-arrow-right ms-1"></i></a>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
	    }
	}
}