<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Work Process Box Widget .
 *
 */
class Konta_Work_Process extends Widget_Base {

	public function get_name() {
		return 'kontaworkprocess';
	}

	public function get_title() {
		return __( 'Konta Work Process', 'konta' );
	}


	public function get_icon() {
		return 'th-icon';
    }


	public function get_categories() {
		return [ 'konta' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'team_section',
			[
				'label' 	=> __( 'Work Process', 'konta' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Work Process Style', 'konta' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> 'layout_one',
				'options' 		=> [
					'layout_one'  		=> __( 'Style One', 'konta' ),
					'layout_two'  		=> __( 'Style Two', 'konta' ),
				]
			]
		);
		
        $this->end_controls_section();




	    include konta_get_elementor_option('workprocess-one-options.php');
	    include konta_get_elementor_option('workprocess-two-options.php');

	

        //-------------------------------------title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Name', '{{WRAPPER}} .title-selector',['layout_one','layout_two'] );

        $this->end_controls_section();


        
        //-------------------------------------description styling-------------------------------------//

        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Content Style', 'konta' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		konta_all_elementor_style($this, 'Content', '{{WRAPPER}} .desc-selector',['layout_one','layout_two'] );

        $this->end_controls_section();
       
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        if( $settings['layout_style'] == 'layout_one' ){

        	echo '<div class="process-card-area">';
                echo '<div class="row gy-50 justify-content-center">';
                	$i = 0;
                    foreach( $settings['process'] as $data ) {
                    	$i++;
                    	$k = str_pad($i, 2, '0', STR_PAD_LEFT);

	                    echo '<div class="col-md-6 col-xl-3">';
	                        echo '<div class="process-card">';
	                        	if( ! empty( $settings['shape']['url'] ) ){
		                            echo '<div class="process-card_bg-shape">';
		                                echo konta_img_tag( array(
				                            'url'       => esc_url( $settings['shape']['url'] ),
				                        ) );
		                            echo '</div>';
		                        }

	                            if( ! empty( $data['icon_image']['url'] ) ){
			                        echo '<div class="process-card_icon">';
			                            echo konta_img_tag( array(
				                            'url'       => esc_url( $data['icon_image']['url'] ),
				                        ) );
			                        echo '</div>';
			                    }
	                            echo '<span class="process-card_subtitle">Step - '.esc_html( $k ).'</span>';
	                            if( ! empty( $data['title'] ) ){
		                            echo '<h4 class="process-card_title title-selector">'.esc_html( $data['title'] ).'</h4>';
		                        }
		                        if( ! empty( $data['content'] ) ){
		                            echo '<p class="process-card_text desc-selector">'.esc_html( $data['content'] ).'</p>';
		                        }
	                        echo '</div>';
	                    echo '</div>';
	                }
                echo '</div>';
            echo '</div>';
	    }else{
	    	echo '<div class="row gy-40 justify-content-between">';
	    		foreach( $settings['2_process'] as $data ) {  
	                echo '<div class="col-sm-6 col-lg-auto process-card2-wrap">';
	                    echo '<div class="process-card2">';
	                    	if( ! empty( $data['icon'] ) ){
		                        echo '<div class="process-card2_icon">'.wp_kses_post($data['icon']).'</div>';
		                    }
	                        if( ! empty( $data['title'] ) ){
			                    echo '<h3 class="process-card2_title title-selector">'.esc_html( $data['title'] ).'</h3>';
			                }
	                        if( ! empty( $data['content'] ) ){
			                    echo '<p class="process-card2_text desc-selector">'.esc_html( $data['content'] ).'</p>';
			                }
	                    echo '</div>';
	                echo '</div>';
	            }   
	        echo '</div>';
	    }
	}
}