<?php

/**
 * @Packge     : Konta
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access

    if( ! defined( 'ABSPATH' ) ){

        exit();

    }

/**

 * Admin Custom Login Logo

 */

function konta_custom_login_logo() {

    $logo = ! empty( konta_opt( 'konta_admin_login_logo', 'url' ) ) ? konta_opt( 'konta_admin_login_logo', 'url' ) : '' ;

    if( isset( $logo ) && ! empty( $logo ) ){

        echo '<style type="text/css">body.login div#login h1 a { background-image:url('.esc_url( $logo ).'); }</style>';
    }
}

add_action( 'login_enqueue_scripts', 'konta_custom_login_logo' );

/**
* Admin Custom css
*/

add_action( 'admin_enqueue_scripts', 'konta_admin_styles' );

function konta_admin_styles() {

  if ( ! empty( $konta_admin_custom_css ) ) {
        $konta_admin_custom_css = str_replace(array("\r\n", "\r", "\n", "\t", '    '), '', $konta_admin_custom_css);
        echo '<style rel="stylesheet" id="konta-admin-custom-css" >';
            echo esc_html( $konta_admin_custom_css );
        echo '</style>';
    }
}

// share button code

 function konta_social_sharing_buttons( ) {

    // Get page URL

    $URL        = get_permalink();
    $Sitetitle  = get_bloginfo('name');
    // Get page title

    $Title  = str_replace( ' ', '%20', get_the_title());

    // Construct sharing URL without using any script

    $twitterURL     = 'https://twitter.com/share?text='.esc_html( $Title ).'&url='.esc_url( $URL );
    $facebookURL    = 'https://www.facebook.com/sharer/sharer.php?u='.esc_url( $URL );
    $pinterest   = 'http://pinterest.com/pin/create/link/?url='.esc_url( $URL ).'&media='.esc_url(get_the_post_thumbnail_url()).'&description='.wp_kses_post(get_the_title());
    $linkedin       = 'https://www.linkedin.com/shareArticle?mini=true&url='.esc_url( $URL ).'&title='.esc_html( $Title );
    // Add sharing button at the end of page/page content

    $content = '';

    $content .= '<a href="'.esc_url( $facebookURL ).'" target="_blank"><i class="fab fa-facebook-f"></i></a>';
    $content .= '<a href="'. esc_url( $twitterURL ) .'" target="_blank"><i class="fab fa-twitter"></i></a>';
    $content .= '<a href="'.esc_url( $linkedin ).'" target="_blank"><i class="fab fa-linkedin-in"></i></a>';
    $content .= '<a href="'.esc_url( $pinterest ).'" target="_blank"><i class="fa-brands fa-pinterest-p"></i></a>';


    return $content;

};


//Post Reading Time Count

function konta_estimated_reading_time() {
    global $post;
    // get the content
    $the_content = $post->post_content;
    // count the number of words
    $words = str_word_count( strip_tags( $the_content ) );
    // rounding off and deviding per 100 words per minute
    $minute = floor( $words / 100 );
    // rounding off to get the seconds
    $second = floor( $words % 100 / ( 100 / 60 ) );
    // calculate the amount of time needed to read
    $estimate = $minute . esc_html__(' Min', 'konta') . ( $minute == 1 ? '' : 's' ) . esc_html__(' Read', 'konta');
    // create output
    $output = $estimate;
    // return the estimate
    return $output;
}



//add SVG to allowed file uploads

function konta_mime_types( $mimes ) {

    $mimes['svg'] = 'image/svg+xml';
    $mimes['svgz'] = 'image/svgz+xml';
    $mimes['exe'] = 'program/exe';
    $mimes['dwg'] = 'image/vnd.dwg';
    return $mimes;
}

add_filter('upload_mimes', 'konta_mime_types');



function konta_wp_check_filetype_and_ext( $data, $file, $filename, $mimes ) {

    $wp_filetype = wp_check_filetype( $filename, $mimes );
    $ext         = $wp_filetype['ext'];
    $type        = $wp_filetype['type'];
    $proper_filename = $data['proper_filename'];

    return compact( 'ext', 'type', 'proper_filename' );

}

add_filter( 'wp_check_filetype_and_ext', 'konta_wp_check_filetype_and_ext', 10, 4 );

if (!function_exists('konta_all_elementor_style')) :
    function konta_all_elementor_style($agrs, $label, $selector, $condition, $style = 'color', $color = true, $typo = true, $mar = true, $pad = true) {
    
        if (false != $color) :
            $agrs->add_control(
                str_replace(' ', '_', $label) . '_color',
                [
                    'label'         => __($label . ' Color', 'konta'),
                    'type'          => \Elementor\Controls_Manager::COLOR,
                    'selectors'     => [
                        $selector   => $style . ': {{VALUE}}',
                    ],
                    'condition'     => [
                        'layout_style' => $condition
                    ]
                ]
            );
        endif;

        if (false != $typo) :
            //title typography
            $agrs->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name'           =>  str_replace(' ', '_', $label) . '_typo',
                    'label'          => esc_html__($label . ' Typography', 'konta'),
                    'selector'       => $selector,
                    'condition' => [
                        'layout_style' => $condition
                    ]
                ]
            );

        endif;

        if (false != $mar) :
            $agrs->add_responsive_control(
                str_replace(' ', '_', $label) . '_margin',
                [
                    'label'         => esc_html__($label . ' Margin', 'konta'),
                    'type'          => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                        $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],

                    'condition' => [
                        'layout_style' => $condition,
                    ]
                ]
            );

        endif;

        if (false != $pad) :
            $agrs->add_responsive_control(
                str_replace(' ', '_', $label) . '_padding',
                [
                    'label'         => esc_html__($label . ' Padding', 'konta'),
                    'type'          => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                        $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],

                    'condition' => [
                        'layout_style' => $condition
                    ]
                ]
            );

        endif;

    }
endif;


//--------------------------------------------------button--------------------------------------------------//

if (!function_exists('konta_elementor_border_style')) :
    function konta_elementor_border_style($agrs, $label, $selector, $condition)
    {

        
        if (false != $selector) :
            $agrs->add_group_control(
                 \Elementor\Group_Control_Border::get_type(),
                [
                    'name'      => $label .'border',
                    'label'     => __($label . ' Border', 'konta'),
                    'selector'  => $selector ,
                    'condition' => [
                        'layout_style' => $condition
                    ]
                ]
            );

            $agrs->add_responsive_control(
                str_replace(' ', '_', $label) . '_border_radious',
                [
                    'label'         => esc_html__($label . ' Border Radious', 'konta'),
                    'type'          => \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units'    => [ 'px', '%', 'em' ],
                    'selectors'     => [
                        $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],

                    'condition' => [
                        'layout_style' => $condition
                    ]
                ]
            );

        endif;
    }
endif;


if (!function_exists('konta_elementor_color_style')) :
    function konta_elementor_color_style($agrs, $label, $selector, $condition, $style = 'color')
    {
        if (false != $selector) :
            $agrs->add_control(
                str_replace(' ', '_', $label) . '_color',
                [
                    'label' => __($label . ' Color', 'konta'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        $selector => $style . ': {{VALUE}}',
                    ],
                    'condition' => [
                        'layout_style' => $condition
                    ]
                ]
            );  
        endif;
    }
endif;

if (!function_exists('konta_elementor_typography_style')) :
    function konta_elementor_typography_style($agrs, $label, $selector, $condition)
    {   
        if (false != $selector) :
            $agrs->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name'           =>  str_replace(' ', '_', $label) . '_typo',
                    'label'          => esc_html__($label . ' Typography', 'konta'),
                    'selector'       => $selector,
                    'condition' => [
                        'layout_style' => $condition
                    ]
                ]
            ); 
        endif;
    }
endif;

//function for load elementor widgets field style wise

if (!function_exists('konta_get_elementor_option')) :
    function konta_get_elementor_option($template_name = null)
    {
        $template_path = apply_filters('konta-elementor/template-options', 'elementor-options/');
        $template = locate_template($template_path . $template_name);
        if (!$template) {
            $template = KONTA_ADDONS  . 'elementor-options/' . $template_name;
        }
        if (file_exists($template)) {
            return $template;
        }
    }
endif;

add_action( 'init','konta_service', 0 );


function konta_service(){

    $labels = array(

        'name'               => esc_html__( 'Services', 'post Category general name', 'konta' ),
        'singular_name'      => esc_html__( 'Service', 'post Category singular name', 'konta' ),
        'menu_name'          => esc_html__( 'Services', 'admin menu', 'konta' ),
        'name_admin_bar'     => esc_html__( 'Service', 'add new on admin bar', 'konta' ),
        'add_new'            => esc_html__( 'Add New', 'Service', 'konta' ),
        'add_new_item'       => esc_html__( 'Add New Service', 'konta' ),
        'new_item'           => esc_html__( 'New Service', 'konta' ),
        'edit_item'          => esc_html__( 'Edit Service', 'konta' ),
        'view_item'          => esc_html__( 'View Service', 'konta' ),
        'all_items'          => esc_html__( 'All Services', 'konta' ),
        'search_items'       => esc_html__( 'Search Services', 'konta' ),
        'parent_item_colon'  => esc_html__( 'Parent Services:', 'konta' ),
        'not_found'          => esc_html__( 'No Services found.', 'konta' ),
        'not_found_in_trash' => esc_html__( 'No Services found in Trash.', 'konta' ),
    );



    $args = array(

        'labels'             => $labels,
        'description'        => esc_html__( 'Description.', 'konta' ),
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'show_in_rest'       => true,
        'menu_icon'          => 'dashicons-index-card',
        'supports'           => array( 'title', 'thumbnail', 'editor', 'excerpt', 'elementor' ),
        'rewrite'            => array( 'slug' => 'all-services' ),
    );

    register_post_type( 'konta_service', $args );

}



// Add Image Size
add_image_size( 'konta_85X85', 85, 85, true );
add_image_size( 'konta_391x280', 391, 280, true );
add_image_size( 'konta_598x270', 598, 270, true );
add_image_size( 'konta_287x280', 287, 280, true );
add_image_size( 'konta_554x397', 554, 397, true );
add_image_size( 'Konta_391X220', 391, 220, true );
add_image_size( 'Konta_218X278', 218, 278, true );
add_image_size( 'Konta_600X309', 600, 309, true );

// add_image_size( 'konta_90X90', 90, 90, true );
// add_image_size( 'konta_387X280', 387, 280, true );
// add_image_size( 'konta_595X300', 595, 300, true );
// add_image_size( 'konta_595X428', 595, 428, true );
// add_image_size( 'konta_245X200', 245, 200, true );
// add_image_size( 'konta_110X100', 110, 100, true );



remove_filter( 'render_block', 'wp_render_layout_support_flag', 10, 2 );
remove_filter( 'render_block', 'gutenberg_render_layout_support_flag', 10, 2 );