<?php
/**
 * @version  1.0
 * @package  konta
 * @author   Konta <
 *
 *
 *
 */

/**************************************
*   Creating Newsletter Widget
***************************************/

class konta_newsletter_widget extends WP_Widget {
	function __construct() {
		parent::__construct(
    		// Base ID of your widget
    		'konta_newsletter_widget',
    		// Widget name will appear in UI
    		esc_html__( 'Konta :: Newsletter', 'konta' ),
    		// Widget description
    		array(
				'description' 	              => esc_html__( 'Add Newsletter', 'konta' ),
				'classname'		              => 'widget_newsletter widget footer-widget',
                'customize_selective_refresh' => true,
			)
		);
	}

// This is where the action happens
public function widget( $args, $instance ) {
	$title 			= apply_filters( 'widget_title', $instance['title'] );
	$placeholder 	= apply_filters( 'widget_placeholder', $instance['placeholder'] );
	$desc 	= apply_filters( 'widget_desc', $instance['desc'] );


	// before and after widget arguments are defined by themes
	echo $args['before_widget'];
    if ( ! empty( $title ) ){
        echo $args['before_title'] . $title . $args['after_title'];
    }
    	echo '<div class="newsletter-widget">';
            echo '<p class="md-10">'.esc_attr( $desc ).'</p>';
            echo '<div class="footer-search-contact mt-25">';
                echo '<form class="newsletter-widget">';
                    echo '<input class="form-control" type="email" placeholder="'.esc_attr( $placeholder ).'">';
                echo '</form>';
               	echo ' <div class="footer-btn mt-10">';
                    echo '<button type="submit" class="th-btn style3 fw-btn">'.esc_html__( 'Subscribe Now','konta' ).' <i class="fa-regular fa-arrow-right"></i></button>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
    echo $args['after_widget'];
}

// Widget Backend
public function form( $instance ) {
	//Title
	if ( isset( $instance[ 'title' ] ) ) {
		$title = $instance[ 'title' ];
	}else {
		$title = esc_html__( 'Subscribe Us', 'konta' );
	}

	// Placeholder Text
	if ( isset( $instance[ 'placeholder' ] ) ) {
		$placeholder = $instance[ 'placeholder' ];
	}else{
		$placeholder = __( 'Your Email Address', 'konta' );
	}
	if ( isset( $instance[ 'desc' ] ) ) {
		$desc = $instance[ 'desc' ];
	}else{
		$desc = __( 'Fusce varius, dolor tempor interdum tristiquei bibendum service life.', 'konta' );
	}

// Widget admin form
	?>
	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>">
			<?php
				_e( 'Title:' ,'konta');
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'placeholder' ); ?>">
			<?php
				_e( 'Placeholder:' ,'konta' );
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'placeholder' ); ?>" name="<?php echo $this->get_field_name( 'placeholder' ); ?>" type="text" value="<?php echo esc_attr( $placeholder ); ?>" />
	</p>

	<p>
		<label for="<?php echo $this->get_field_id( 'desc' ); ?>">
			<?php
				_e( 'Description:' ,'konta' );
			?>
		</label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'desc' ); ?>" name="<?php echo $this->get_field_name( 'desc' ); ?>" type="text" value="<?php echo esc_attr( $desc ); ?>" />
	</p>
<?php
	}
// Updating widget replacing old instances with new
public function update( $new_instance, $old_instance ) {
    	$instance 					= array();
    	$instance['title'] 			= ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
    	$instance['placeholder']  	= ( ! empty( $new_instance['placeholder'] ) ) ? strip_tags( $new_instance['placeholder'] ) : '';
    	$instance['desc']  	= ( ! empty( $new_instance['desc'] ) ) ? strip_tags( $new_instance['desc'] ) : '';

    	return $instance;
	}
} // Class konta_subscribe_widget ends here


// Register and load the widget
function konta_newsletter_load_widget() {
	register_widget( 'konta_newsletter_widget' );
}
add_action( 'widgets_init', 'konta_newsletter_load_widget' );