<?php
/**
 * 
 * Plugin Name: Konta Core
 * Description: This is a helper plugin of konta theme
 * Version:     1.0
 * Author:      Themeholy
 * Author URI:  https://themeforest.net/user/themeholy 
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path: /languages
 * Text Domain: konta
 * 
 */

// Blocking direct access

if( ! defined( 'ABSPATH' ) ) {

    exit();

}

// Define Constant

define( 'KONTA_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

define( 'KONTA_PLUGIN_INC_PATH', plugin_dir_path( __FILE__ ) . 'inc/' );
define( 'KONTA_PLUGIN_CMB2EXT_PATH', plugin_dir_path( __FILE__ ) . 'cmb2-ext/' );

define( 'KONTA_PLUGIN_WIDGET_PATH', plugin_dir_path( __FILE__ ) . 'inc/widgets/' );

define( 'KONTA_PLUGDIRURI', plugin_dir_url( __FILE__ ) );

define( 'KONTA_ADDONS', plugin_dir_path( __FILE__ ) .'addons/' );

define( 'KONTA_ASSETS', plugin_dir_url( __FILE__ ) .'assets/' );

define( 'KONTA_CORE_PLUGIN_TEMP', plugin_dir_path( __FILE__ ) .'konta-template/' );

// load textdomain

load_plugin_textdomain( 'konta', false, basename( dirname( __FILE__ ) ) . '/languages' );

//include file.

require_once KONTA_PLUGIN_INC_PATH .'kontacore-functions.php';
require_once KONTA_PLUGIN_INC_PATH .'builder/builder.php';
require_once KONTA_PLUGIN_INC_PATH . 'MCAPI.class.php';
require_once KONTA_PLUGIN_INC_PATH .'kontaajax.php';

require_once KONTA_PLUGIN_CMB2EXT_PATH . 'cmb2ext-init.php';

//Widget

// require_once KONTA_PLUGIN_WIDGET_PATH . 'recent-post-widget.php';
// require_once KONTA_PLUGIN_WIDGET_PATH . 'search-form.php';
// require_once KONTA_PLUGIN_WIDGET_PATH . 'categories-lists.php';
require_once KONTA_PLUGIN_WIDGET_PATH . 'about-us-widget.php';
// require_once KONTA_PLUGIN_WIDGET_PATH . 'newslater-konta-widget.php';
require_once KONTA_PLUGIN_WIDGET_PATH . 'recent-post-for-blog.php';
// // require_once KONTA_PLUGIN_WIDGET_PATH . 'author-widget.php';
// require_once KONTA_PLUGIN_WIDGET_PATH . 'offer-banner.php';

//addons

require_once KONTA_ADDONS . 'addons.php';

// Register widget styles
add_action( 'elementor/editor/after_enqueue_scripts', 'widget_styles' );

function widget_styles() {

    wp_register_style( 'editor-style-1', plugins_url( 'assets/css/editor.css', __FILE__ ) );
    wp_enqueue_style( 'editor-style-1' );

}
